/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TEInventory;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.TechConfig;
import tfctech.client.TechSounds;
import tfctech.client.audio.IMachineSoundEffect;
import tfctech.objects.blocks.devices.BlockElectricForge;
import tfctech.objects.storage.MachineEnergyContainer;

@ParametersAreNonnullByDefault
@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public class TEElectricForge
extends TEInventory
implements ITickable,
ITileFields,
IMachineSoundEffect,
IEnergySink {
    public static final int SLOT_INPUT_MIN = 0;
    public static final int SLOT_INPUT_MAX = 8;
    public static final int SLOT_EXTRA_MIN = 9;
    public static final int SLOT_EXTRA_MAX = 11;
    private final HeatRecipe[] cachedRecipes = new HeatRecipe[9];
    private final MachineEnergyContainer energyContainer;
    private float targetTemperature = 0.0f;
    private int litTime = 0;
    private boolean soundPlay = false;
    private boolean addedToIc2Network = false;

    public TEElectricForge() {
        super(12);
        this.energyContainer = new MachineEnergyContainer(TechConfig.DEVICES.electricForgeEnergyCapacity, TechConfig.DEVICES.electricForgeEnergyCapacity, 0);
        Arrays.fill(this.cachedRecipes, null);
    }

    public void addTargetTemperature(int value) {
        this.targetTemperature += (float)value;
        if (this.targetTemperature > (float)TechConfig.DEVICES.electricForgeMaxTemperature) {
            this.targetTemperature = (float)TechConfig.DEVICES.electricForgeMaxTemperature;
        }
        if (this.targetTemperature < 0.0f) {
            this.targetTemperature = 0.0f;
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToIc2Network = false;
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && TechConfig.DEVICES.acceptIc2EU && !this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToIc2Network = true;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            IMachineSoundEffect.super.update();
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        int energyUsage = (int)((float)TechConfig.DEVICES.electricForgeEnergyConsumption * this.targetTemperature / 100.0f);
        if (energyUsage < 1) {
            energyUsage = 1;
        }
        for (int i = 0; i <= 8; ++i) {
            float modifier;
            ItemStack stack = this.inventory.getStackInSlot(i);
            IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            float f = modifier = stack.func_77973_b() instanceof IMetalItem ? (float)((IMetalItem)stack.func_77973_b()).getSmeltAmount(stack) / 100.0f : 1.0f;
            if (cap == null) continue;
            float itemTemp = cap.getTemperature();
            int energy = (int)((float)energyUsage * modifier);
            if (this.targetTemperature > itemTemp && this.energyContainer.consumeEnergy(energy, false)) {
                float heatSpeed = (float)TechConfig.DEVICES.electricForgeSpeed * 15.0f;
                float temp = cap.getTemperature() + heatSpeed * cap.getHeatCapacity() * (float)ConfigTFC.Devices.TEMPERATURE.globalModifier;
                cap.setTemperature(Math.min(temp, this.targetTemperature));
                this.litTime = 15;
            }
            this.handleInputMelting(stack, i);
        }
        if (--this.litTime <= 0) {
            this.litTime = 0;
            state = state.func_177226_a((IProperty)BlockElectricForge.LIT, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
        } else {
            state = state.func_177226_a((IProperty)BlockElectricForge.LIT, (Comparable)Boolean.valueOf(true));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
        }
    }

    public void setAndUpdateSlots(int slot) {
        this.func_70296_d();
        this.updateCachedRecipes();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.targetTemperature = nbt.func_74760_g("targetTemperature");
        this.energyContainer.deserializeNBT(nbt.func_74775_l("energyContainer"));
        super.func_145839_a(nbt);
        this.updateCachedRecipes();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74776_a("targetTemperature", this.targetTemperature);
        nbt.func_74782_a("energyContainer", (NBTBase)this.energyContainer.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing == null || facing == EnumFacing.UP || facing == EnumFacing.DOWN || facing == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockElectricForge.field_185512_D)).func_176734_d()) {
            if (capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == null || facing == EnumFacing.UP || facing == EnumFacing.DOWN || facing == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockElectricForge.field_185512_D)).func_176734_d()) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.energyContainer);
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return (T)this.energyContainer.getGTCEHandler();
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot <= 8) {
            return stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
    }

    public int getFieldCount() {
        return 2;
    }

    public void setField(int index, int value) {
        if (index == 0) {
            this.targetTemperature = value;
        } else if (index == 1) {
            this.energyContainer.setEnergy(value);
        } else {
            TFCTech.getLog().warn("Invalid field ID {} in TEElectricForge#setField", (Object)index);
        }
    }

    public int getField(int index) {
        if (index == 0) {
            return (int)this.targetTemperature;
        }
        if (index == 1) {
            return this.energyContainer.getEnergyStored();
        }
        TFCTech.getLog().warn("Invalid field ID {} in TEElectricForge#setField", (Object)index);
        return 0;
    }

    public int getEnergyCapacity() {
        return this.energyContainer.getMaxEnergyStored();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSoundEvent() {
        return TechSounds.INDUCTION_WORK;
    }

    @Override
    public boolean shouldPlay() {
        if (!this.func_145837_r()) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockElectricForge && (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockElectricForge.LIT) != false;
    }

    @Override
    public boolean isPlaying() {
        return this.soundPlay;
    }

    @Override
    public void setPlaying(boolean value) {
        this.soundPlay = value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getSoundPos() {
        return this.func_174877_v();
    }

    public int getEnergyStored() {
        return this.energyContainer.getEnergyStored();
    }

    public double getDemandedEnergy() {
        return Math.ceil((double)this.energyContainer.receiveEnergy(Integer.MAX_VALUE, true) / (double)TechConfig.DEVICES.ratioIc2);
    }

    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public double injectEnergy(EnumFacing facing, double amount, double voltage) {
        this.energyContainer.receiveEnergy((int)Math.ceil(amount) * TechConfig.DEVICES.ratioIc2, false);
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing facing) {
        return TechConfig.DEVICES.acceptIc2EU && (facing == EnumFacing.UP || facing == EnumFacing.DOWN || facing == ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockElectricForge.field_185512_D)).func_176734_d());
    }

    private void handleInputMelting(ItemStack stack, int index) {
        HeatRecipe recipe = this.cachedRecipes[index];
        IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        if (recipe != null && cap != null && recipe.isValidTemperature(cap.getTemperature())) {
            FluidStack fluidStack = recipe.getOutputFluid(stack);
            float itemTemperature = cap.getTemperature();
            if (fluidStack != null) {
                for (int i = 9; i <= 11 && fluidStack.amount > 0; ++i) {
                    int amountFilled;
                    ItemStack output = this.inventory.getStackInSlot(i);
                    IFluidHandler fluidHandler = (IFluidHandler)output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (fluidHandler == null || (amountFilled = fluidHandler.fill(fluidStack.copy(), true)) <= 0) continue;
                    fluidStack.amount -= amountFilled;
                    IItemHeat heatHandler = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                    if (heatHandler == null) continue;
                    heatHandler.setTemperature(itemTemperature);
                }
            }
            this.inventory.setStackInSlot(index, recipe.getOutputStack(stack));
        }
    }

    private void updateCachedRecipes() {
        for (int i = 0; i <= 8; ++i) {
            this.cachedRecipes[i] = null;
            ItemStack inputStack = this.inventory.getStackInSlot(i);
            if (inputStack.func_190926_b()) continue;
            this.cachedRecipes[i] = HeatRecipe.get((ItemStack)inputStack);
        }
    }
}

