/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.storage;

import gregtech.api.capability.IEnergyContainer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TechConfig;

public class MachineEnergyContainer
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    private final GTCEHandler gtceHandler = new GTCEHandler(this);

    public MachineEnergyContainer(@Nullable NBTTagCompound nbt) {
        this(10000, 10000, 0);
        this.deserializeNBT(nbt);
    }

    public MachineEnergyContainer(int capacity, int maxReceive, int energy) {
        super(capacity, maxReceive, 0, energy);
    }

    public boolean consumeEnergy(int amount, boolean simulate) {
        if (amount > this.energy) {
            return false;
        }
        if (!simulate) {
            this.energy -= amount;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEnergy(int amount) {
        this.energy = amount;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.energy = nbt.func_74762_e("energy");
        }
    }

    public GTCEHandler getGTCEHandler() {
        return this.gtceHandler;
    }

    @Optional.Interface(iface="gregtech.api.capability.IEnergyContainer", modid="gregtech")
    public static class GTCEHandler
    implements IEnergyContainer {
        private final MachineEnergyContainer container;

        public GTCEHandler(MachineEnergyContainer mainContainer) {
            this.container = mainContainer;
        }

        public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
            long amperesAccepted;
            long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
            if (voltage > 0L && amperage > 0L && canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage()))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                return amperesAccepted;
            }
            return 0L;
        }

        public boolean inputsEnergy(EnumFacing enumFacing) {
            return true;
        }

        public long changeEnergy(long energyToAdd) {
            long newEnergyStored;
            long oldEnergyStored = this.getEnergyStored();
            long l = newEnergyStored = this.getEnergyCapacity() - this.getEnergyStored() < energyToAdd ? this.getEnergyCapacity() : oldEnergyStored + energyToAdd;
            if (newEnergyStored < 0L) {
                newEnergyStored = 0L;
            }
            this.setEnergyStored(newEnergyStored);
            return newEnergyStored - oldEnergyStored;
        }

        public long getEnergyStored() {
            return (long)Math.floor((double)this.container.getEnergyStored() / (double)TechConfig.DEVICES.ratioGTCE);
        }

        public void setEnergyStored(long energyStored) {
            this.container.setEnergy((int)(energyStored * (long)TechConfig.DEVICES.ratioGTCE));
        }

        public long getEnergyCapacity() {
            return (long)Math.ceil((double)this.container.getMaxEnergyStored() / (double)TechConfig.DEVICES.ratioGTCE);
        }

        public long getInputAmperage() {
            return 1L;
        }

        public long getInputVoltage() {
            return TechConfig.DEVICES.gtceVoltage;
        }

        public boolean isOneProbeHidden() {
            return true;
        }
    }
}

