/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfctech.objects.items.ceramics.ItemTechMold;
import tfctech.objects.items.metal.ItemTechMetal;

public class UnmoldRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final NonNullList<Ingredient> input;
    private final ResourceLocation group;
    private final ItemTechMetal.ItemType type;
    private final float chance;

    public UnmoldRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemTechMetal.ItemType type, float chance) {
        this.group = group;
        this.input = input;
        this.type = type;
        this.chance = chance;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        boolean foundMold = false;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemTechMold) {
                ItemTechMold moldItem = (ItemTechMold)stack.func_77973_b();
                IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (cap instanceof IMoldHandler) {
                    IMoldHandler moldHandler = (IMoldHandler)cap;
                    if (!moldHandler.isMolten()) {
                        Metal metal = moldHandler.getMetal();
                        if (metal != null && moldItem.type.equals((Object)this.type) && !foundMold) {
                            foundMold = true;
                            continue;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return foundMold;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        IMoldHandler moldHandler;
        IFluidHandler moldCap;
        ItemStack moldStack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemTechMold) {
                ItemTechMold tmp = (ItemTechMold)stack.func_77973_b();
                if (tmp.type.equals((Object)this.type) && moldStack == null) {
                    moldStack = stack;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        if (moldStack != null && (moldCap = (IFluidHandler)moldStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) instanceof IMoldHandler && !(moldHandler = (IMoldHandler)moldCap).isMolten() && moldHandler.getAmount() == 100) {
            return this.getOutputItem(moldHandler);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemTechMold)) continue;
            EntityPlayer player = ForgeHooks.getCraftingPlayer();
            if (player.field_70170_p.field_72995_K) continue;
            if (!(stack = this.getMoldResult(stack)).func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
                continue;
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    public ItemTechMetal.ItemType getType() {
        return this.type;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getMoldResult(ItemStack moldIn) {
        if (Constants.RNG.nextFloat() <= this.chance) {
            return new ItemStack(moldIn.func_77973_b());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getOutputItem(IMoldHandler moldHandler) {
        ItemTechMetal item;
        Metal m = moldHandler.getMetal();
        if (m != null && (item = ItemTechMetal.get(m, this.type)) != null) {
            ItemStack output = new ItemStack((Item)item);
            IItemHeat heat = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            if (heat != null) {
                heat.setTemperature(moldHandler.getTemperature());
            }
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            NonNullList ingredients = RecipeUtils.parseShapeless((JsonContext)context, (JsonObject)json);
            String result = JsonUtils.func_151200_h((JsonObject)json, (String)"result");
            ItemTechMetal.ItemType type = ItemTechMetal.ItemType.valueOf(result.toUpperCase());
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            float chance = 0.0f;
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"chance")) {
                chance = JsonUtils.func_151217_k((JsonObject)json, (String)"chance");
            }
            return new UnmoldRecipe(group.isEmpty() ? new ResourceLocation(result) : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, type, chance);
        }
    }
}

