/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.dries007.tfc.Constants;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfctech.objects.items.glassworking.ItemGlassMolder;

public class UnmoldGlassRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final NonNullList<Ingredient> input;
    private final ResourceLocation group;
    private final ItemStack result;
    private final float chance;

    public UnmoldGlassRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, float chance) {
        this.group = group;
        this.input = input;
        this.result = result;
        this.chance = chance;
    }

    public float getChance() {
        return this.chance;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        boolean found = false;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (found) {
                return false;
            }
            for (Ingredient ingredient : this.func_192400_c()) {
                if (!ingredient.apply(stack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return found;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemGlassMolder.GlassMolderCapability cap;
        IFluidHandler moldCap;
        ItemStack moldStack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (moldStack != null) {
                return ItemStack.field_190927_a;
            }
            for (Ingredient ingredient : this.func_192400_c()) {
                if (!ingredient.apply(stack)) continue;
                moldStack = stack;
                break;
            }
            if (moldStack != null) continue;
            return ItemStack.field_190927_a;
        }
        if (moldStack != null && (moldCap = (IFluidHandler)moldStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) instanceof ItemGlassMolder.GlassMolderCapability && (cap = (ItemGlassMolder.GlassMolderCapability)moldCap).isSolidified()) {
            return this.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            EntityPlayer player = ForgeHooks.getCraftingPlayer();
            if (player.field_70170_p.field_72995_K) continue;
            if (Constants.RNG.nextFloat() <= this.chance) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(stack.func_77973_b()));
                break;
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
            break;
        }
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            NonNullList ingredients = RecipeUtils.parseShapeless((JsonContext)context, (JsonObject)json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            float chance = 0.0f;
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"chance")) {
                chance = JsonUtils.func_151217_k((JsonObject)json, (String)"chance");
            }
            return new UnmoldGlassRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result, chance);
        }
    }
}

