/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items.metal;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.items.ItemTFC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tfctech.objects.items.metal.ItemGear;
import tfctech.objects.items.metal.ItemGroove;
import tfctech.objects.items.metal.ItemWire;

public class ItemTechMetal
extends ItemTFC
implements IMetalItem {
    private static final Map<Metal, EnumMap<ItemType, ItemTechMetal>> TABLE = new HashMap<Metal, EnumMap<ItemType, ItemTechMetal>>();
    protected final Metal metal;
    protected final ItemType type;

    @Nullable
    public static ItemTechMetal get(Metal metal, ItemType type) {
        return TABLE.get(metal).get((Object)type);
    }

    public ItemTechMetal(Metal metal, ItemType type) {
        this.metal = metal;
        this.type = type;
        if (!TABLE.containsKey(metal)) {
            TABLE.put(metal, new EnumMap(ItemType.class));
        }
        TABLE.get(metal).put(type, this);
        this.setNoRepair();
    }

    public ItemType getType() {
        return this.type;
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        switch (this.type) {
            case WIRE: 
            case BOWL_MOUNT: {
                return Size.LARGE;
            }
            case GEAR: 
            case RACKWHEEL: {
                return Size.NORMAL;
            }
        }
        return Size.SMALL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        switch (this.type) {
            case GEAR: 
            case RACKWHEEL: {
                return Weight.HEAVY;
            }
            case WIRE: 
            case GROOVE: 
            case SLEEVE: 
            case STRIP: {
                return Weight.LIGHT;
            }
        }
        return Weight.MEDIUM;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String metalName = new TextComponentTranslation("tfc.types.metal." + this.metal.getRegistryName().func_110623_a().toLowerCase(), new Object[0]).func_150254_d();
        return new TextComponentTranslation("item.tfctech.metalitem." + this.type.name().toLowerCase() + ".name", new Object[]{metalName}).func_150254_d();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Nonnull
    public Metal getMetal(ItemStack itemStack) {
        return this.metal;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        return this.type.getSmeltAmount();
    }

    public static enum ItemType {
        BOWL_MOUNT(100),
        DRAW_PLATE(100),
        GROOVE(50, false, ItemGroove::new),
        INDUCTOR(200),
        TONGS(100),
        STRIP(50),
        LONG_ROD(100),
        ROD(50),
        BOLT(25),
        SCREW(25),
        SLEEVE(100, true),
        RACKWHEEL_PIECE(100, true),
        RACKWHEEL(400),
        GEAR(400, false, ItemGear::new),
        WIRE(50, false, ItemWire::new);

        private final int smeltAmount;
        private final boolean hasMold;
        private final BiFunction<Metal, ItemType, Item> supplier;

        public static Item create(Metal metal, ItemType type) {
            return type.supplier.apply(metal, type);
        }

        private ItemType(int smeltAmount) {
            this(smeltAmount, false);
        }

        private ItemType(int smeltAmount, boolean hasMold) {
            this(smeltAmount, hasMold, ItemTechMetal::new);
        }

        private ItemType(@Nonnull int smeltAmount, boolean hasMold, BiFunction<Metal, ItemType, Item> supplier) {
            this.smeltAmount = smeltAmount;
            this.hasMold = hasMold;
            this.supplier = supplier;
        }

        public int getSmeltAmount() {
            return this.smeltAmount;
        }

        public boolean hasMold() {
            return this.hasMold;
        }
    }
}

