/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items.metal;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tfctech.TechConfig;
import tfctech.client.TechSounds;
import tfctech.objects.blocks.TechBlocks;
import tfctech.objects.blocks.devices.BlockLatexExtractor;
import tfctech.objects.items.metal.ItemTechMetal;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemGroove
extends ItemTechMetal {
    public ItemGroove(Metal metal, ItemTechMetal.ItemType type) {
        super(metal, type);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (this.isValidBlock(state)) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                if (worldIn.func_175623_d(pos.func_177972_a(face))) continue;
                return EnumActionResult.PASS;
            }
            BlockPos trunkPos = pos;
            while (worldIn.func_180495_p(trunkPos.func_177977_b()).func_177230_c() == state.func_177230_c()) {
                trunkPos = trunkPos.func_177977_b();
            }
            do {
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    if (!(worldIn.func_180495_p(trunkPos.func_177972_a(face)).func_177230_c() instanceof BlockLatexExtractor)) continue;
                    return EnumActionResult.PASS;
                }
            } while (worldIn.func_180495_p(trunkPos = trunkPos.func_177984_a()).func_177230_c() == state.func_177230_c());
            int hammerSlot = -1;
            boolean isOffhand = false;
            ItemStack offhand = player.func_184592_cb();
            if (offhand.func_77973_b().getToolClasses(offhand).contains("hammer")) {
                isOffhand = true;
            } else {
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (!stack.func_77973_b().getToolClasses(stack).contains("hammer")) continue;
                    hammerSlot = i;
                    break;
                }
            }
            if (hammerSlot > -1 || isOffhand) {
                if (isOffhand) {
                    offhand.func_77972_a(1, (EntityLivingBase)player);
                } else {
                    player.field_71071_by.func_70301_a(hammerSlot).func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184586_b(hand).func_190918_g(1);
                if (!worldIn.field_72995_K) {
                    worldIn.func_184133_a(null, pos, TechSounds.RUBBER_GROOVE_FIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    worldIn.func_175656_a(pos.func_177972_a(facing), TechBlocks.LATEX_EXTRACTOR.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean isValidBlock(IBlockState state) {
        ResourceLocation resourceLocation = state.func_177230_c().getRegistryName();
        for (String entry : TechConfig.TWEAKS.rubberTrees) {
            String[] params;
            int paramStart = entry.indexOf("{");
            int paramEnd = entry.indexOf("}");
            String id = paramStart > -1 ? entry.substring(0, paramStart).trim() : entry;
            if (resourceLocation == null || !id.equals(resourceLocation.toString())) continue;
            for (String param : params = entry.substring(paramStart + 1, paramEnd).split(",")) {
                boolean valid = false;
                String paramName = param.substring(0, param.indexOf("=")).trim();
                String paramValue = param.substring(param.indexOf("=") + 1).trim();
                for (IProperty property : state.func_177228_b().keySet()) {
                    if (!property.func_177701_a().equals(paramName)) continue;
                    if (!state.func_177229_b(property).toString().equals(paramValue)) break;
                    valid = true;
                    break;
                }
                if (valid) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

