/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items.glassworking;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.objects.fluids.TechFluids;
import tfctech.objects.items.ItemMiscTech;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemGlassMolder
extends ItemMiscTech {
    public static final int BLOWPIPE_TANK = 250;
    public static final int PANE_TANK = 375;
    public static final int BLOCK_TANK = 1000;
    private final int capacity;

    public ItemGlassMolder(int capacity) {
        super(Size.LARGE, Weight.LIGHT);
        this.func_77625_d(1);
        this.capacity = capacity;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new GlassMolderCapability(stack, this.capacity, nbt);
    }

    public static class GlassMolderCapability
    extends ItemHeatHandler
    implements ICapabilityProvider,
    IFluidHandlerItem {
        private final FluidWhitelistHandler tank;
        private final int capacity;

        GlassMolderCapability(ItemStack stack, int capacity, @Nullable NBTTagCompound nbt) {
            this.capacity = capacity;
            this.heatCapacity = 1.0f;
            this.meltTemp = Heat.maxVisibleTemperature();
            this.tank = new FluidWhitelistHandler(stack, capacity, (Set)Sets.newHashSet((Object[])new Fluid[]{TechFluids.GLASS.get()}));
            this.deserializeNBT(nbt);
        }

        public boolean canWork() {
            FluidStack fluidStack = this.getFluid();
            return fluidStack != null && this.getTemperature() + 273.0f >= (float)fluidStack.getFluid().getTemperature();
        }

        public boolean isSolidified() {
            FluidStack fluidStack = this.getFluid();
            return fluidStack != null && this.getTemperature() + 273.0f < (float)fluidStack.getFluid().getTemperature();
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)((Object)(this.hasCapability(capability, facing) ? this : null));
        }

        @Nonnull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            FluidStack fluidStack = this.tank.drain(this.capacity, false);
            if (fluidStack != null) {
                nbt.func_74782_a("tank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            }
            return nbt;
        }

        public void deserializeNBT(@Nullable NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (nbt != null) {
                this.tank.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank")), true);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> tooltip) {
            FluidStack fluid = this.tank.drain(this.capacity, false);
            if (fluid != null) {
                String fluidDesc = TextFormatting.DARK_GREEN + fluid.getLocalizedName() + TextFormatting.WHITE;
                if (this.isSolidified()) {
                    fluidDesc = fluidDesc + I18n.func_135052_a((String)"tfc.tooltip.solid", (Object[])new Object[0]);
                } else if (this.canWork()) {
                    fluidDesc = fluidDesc + I18n.func_135052_a((String)"tfc.tooltip.liquid", (Object[])new Object[0]);
                }
                tooltip.add(fluidDesc);
            }
            super.addHeatInfo(stack, tooltip);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.tank.drain(this.capacity, false), this.capacity)};
        }

        public int fill(FluidStack fluidStack, boolean doFill) {
            if (fluidStack.amount < this.capacity) {
                return 0;
            }
            int value = this.tank.fill(fluidStack, doFill);
            if (doFill && value > 0) {
                this.setTemperature(fluidStack.getFluid().getTemperature());
            }
            return value;
        }

        @Nullable
        public FluidStack drain(FluidStack fluidStack, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxAmount, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.tank.drain(this.capacity, false);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.tank.getContainer();
        }

        public void empty() {
            this.tank.drain(this.capacity, true);
        }
    }
}

