/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items.glassworking;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import tfctech.client.TechGuiHandler;
import tfctech.objects.items.glassworking.ItemGlassMolder;

public class ItemBlowpipe
extends ItemGlassMolder
implements IMetalItem {
    private static final Map<Metal, ItemBlowpipe> TABLE = new HashMap<Metal, ItemBlowpipe>();
    private final Metal metal;

    @Nullable
    public static ItemBlowpipe get(Metal metal) {
        return TABLE.get(metal);
    }

    public ItemBlowpipe(Metal metal) {
        super(250);
        this.metal = metal;
        if (!TABLE.containsKey(metal)) {
            TABLE.put(metal, this);
        }
        this.func_77625_d(1);
        this.func_77656_e(metal.getToolMetal().func_77997_a() / 2);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        IItemHeat cap;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !player.func_70093_af() && (cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) instanceof ItemGlassMolder.GlassMolderCapability && ((ItemGlassMolder.GlassMolderCapability)cap).canWork()) {
            TechGuiHandler.openGui(world, player.func_180425_c(), player, TechGuiHandler.Type.GLASSWORKING);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String metalName = new TextComponentTranslation("tfc.types.metal." + this.metal.getRegistryName().func_110623_a().toLowerCase(), new Object[0]).func_150254_d();
        return new TextComponentTranslation("item.tfctech.metalitem.blowpipe.name", new Object[]{metalName}).func_150254_d();
    }

    @Nullable
    public Metal getMetal(ItemStack itemStack) {
        return this.metal;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        return 200;
    }
}

