/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items.ceramics;

import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfctech.objects.items.metal.ItemTechMetal;

public class ItemTechMold
extends ItemPottery {
    private static final EnumMap<ItemTechMetal.ItemType, ItemTechMold> MAP = new EnumMap(ItemTechMetal.ItemType.class);
    public final ItemTechMetal.ItemType type;

    public static ItemTechMold get(ItemTechMetal.ItemType category) {
        return MAP.get((Object)category);
    }

    public ItemTechMold(ItemTechMetal.ItemType type) {
        this.type = type;
        if (MAP.put(type, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        Metal metal;
        IFluidHandler capFluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (capFluidHandler instanceof IMoldHandler && (metal = ((IMoldHandler)capFluidHandler).getMetal()) != null) {
            String metalName = new TextComponentTranslation("tfc.types.metal." + metal.getRegistryName().func_110623_a().toLowerCase(), new Object[0]).func_150254_d();
            return new TextComponentTranslation("item.tfctech.ceramics.mold." + this.type.name().toLowerCase() + ".filled", new Object[]{metalName}).func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FilledMoldCapability(nbt);
    }

    public int getItemStackLimit(ItemStack stack) {
        IMoldHandler moldHandler = (IMoldHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (moldHandler != null && moldHandler.getMetal() != null) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    public class FilledMoldCapability
    extends ItemHeatHandler
    implements ICapabilityProvider,
    IMoldHandler {
        private final FluidTank tank = new FluidTank(100);
        private IFluidTankProperties[] fluidTankProperties;

        public FilledMoldCapability(NBTTagCompound nbt) {
            if (nbt != null) {
                this.deserializeNBT(nbt);
            }
        }

        @Nullable
        public Metal getMetal() {
            return this.tank.getFluid() != null ? FluidsTFC.getMetalFromFluid((Fluid)this.tank.getFluid().getFluid()) : null;
        }

        public int getAmount() {
            return this.tank.getFluidAmount();
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.fluidTankProperties == null) {
                this.fluidTankProperties = new IFluidTankProperties[]{new FluidTankPropertiesWrapper(this.tank)};
            }
            return this.fluidTankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            Metal metal;
            if (resource != null && (metal = FluidsTFC.getMetalFromFluid((Fluid)resource.getFluid())) != null && ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(true)) {
                int fillAmount = this.tank.fill(resource, doFill);
                if (fillAmount == this.tank.getFluidAmount()) {
                    this.updateFluidData();
                }
                return fillAmount;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.getTemperature() >= this.meltTemp ? this.tank.drain(resource, doDrain) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.getTemperature() > this.meltTemp) {
                FluidStack stack = this.tank.drain(maxDrain, doDrain);
                if (this.tank.getFluidAmount() == 0) {
                    this.updateFluidData();
                }
                return stack;
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void addHeatInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
            Metal metal = this.getMetal();
            if (metal != null) {
                String desc = TextFormatting.DARK_GREEN + I18n.func_135052_a((String)Helpers.getTypeName((IForgeRegistryEntry)metal), (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{this.getAmount()});
                if (this.isMolten()) {
                    desc = desc + I18n.func_135052_a((String)"tfc.tooltip.liquid", (Object[])new Object[0]);
                }
                text.add(desc);
            }
            super.addHeatInfo(stack, text);
        }

        public float getHeatCapacity() {
            return this.heatCapacity;
        }

        public float getMeltTemp() {
            return this.meltTemp;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHeat.ITEM_HEAT_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)((Object)(this.hasCapability(capability, facing) ? this : null));
        }

        @Nonnull
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            float temp = this.getTemperature();
            nbt.func_74776_a("heat", temp);
            if (temp <= 0.0f) {
                nbt.func_74772_a("ticks", -1L);
            } else {
                nbt.func_74772_a("ticks", CalendarTFC.PLAYER_TIME.getTicks());
            }
            return this.tank.writeToNBT(nbt);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt != null) {
                this.temperature = nbt.func_74760_g("heat");
                this.lastUpdateTick = nbt.func_74763_f("ticks");
                this.tank.readFromNBT(nbt);
            }
            this.updateFluidData();
        }

        private void updateFluidData() {
            this.updateFluidData(this.tank.getFluid());
        }

        private void updateFluidData(FluidStack fluid) {
            Metal metal;
            this.meltTemp = Heat.maxVisibleTemperature();
            this.heatCapacity = 1.0f;
            if (fluid != null && (metal = FluidsTFC.getMetalFromFluid((Fluid)fluid.getFluid())) != null) {
                this.meltTemp = metal.getMeltTemp();
                this.heatCapacity = metal.getSpecificHeat();
            }
        }
    }
}

