/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.items;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.ToolMaterialsTFC;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfctech.objects.blocks.TechBlocks;
import tfctech.objects.items.ItemMiscHeatable;
import tfctech.objects.items.ItemMiscTech;
import tfctech.objects.items.ceramics.ItemFluidBowl;
import tfctech.objects.items.ceramics.ItemTechMold;
import tfctech.objects.items.glassworking.ItemBlowpipe;
import tfctech.objects.items.glassworking.ItemGlassMolder;
import tfctech.objects.items.metal.ItemGroove;
import tfctech.objects.items.metal.ItemTechMetal;

@Mod.EventBusSubscriber(modid="tfctech")
@GameRegistry.ObjectHolder(value="tfctech")
public final class TechItems {
    @GameRegistry.ObjectHolder(value="metal/iron_groove")
    public static final ItemGroove IRON_GROOVE = (ItemGroove)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/iron_bowl_mount")
    public static final ItemTechMetal IRON_BOWL_MOUNT = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="ceramics/fluid_bowl")
    public static final ItemFluidBowl FLUID_BOWL = (ItemFluidBowl)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="latex/vulcanizing_agents")
    public static final ItemMiscTech VULCANIZING_AGENTS = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="latex/rubber_mix")
    public static final ItemMiscHeatable RUBBER_MIX = (ItemMiscHeatable)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="latex/rubber")
    public static final ItemMiscHeatable RUBBER = (ItemMiscHeatable)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="ceramics/unfired/glass_block")
    public static final ItemPottery UNFIRED_MOLD_BLOCK = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/mold/glass_block")
    public static final ItemGlassMolder MOLD_BLOCK = (ItemGlassMolder)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="ceramics/unfired/glass_pane")
    public static final ItemPottery UNFIRED_MOLD_PANE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/mold/glass_pane")
    public static final ItemGlassMolder MOLD_PANE = (ItemGlassMolder)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="powder/lime")
    public static final ItemMiscTech LIME = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="powder/potash")
    public static final ItemMiscTech POTASH = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="pot_potash")
    public static final ItemPottery POTASH_POT = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="powder/wood")
    public static final ItemMiscTech WOOD_POWDER = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="powder/ash")
    public static final ItemMiscTech ASH = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="pot_ash")
    public static final ItemPottery ASH_POT = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="metal/iron_draw_plate")
    public static final ItemTechMetal IRON_DRAW_PLATE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/steel_draw_plate")
    public static final ItemTechMetal STEEL_DRAW_PLATE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/black_steel_draw_plate")
    public static final ItemTechMetal BLACK_STEEL_DRAW_PLATE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/iron_tongs")
    public static final ItemTechMetal IRON_TONGS = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="wiredraw/leather_belt")
    public static final ItemMiscTech LEATHER_BELT = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="wiredraw/winch")
    public static final ItemMiscTech WINCH = (ItemMiscTech)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/copper_inductor")
    public static final ItemTechMetal COPPER_INDUCTOR = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/tin_sleeve")
    public static final ItemTechMetal TIN_SLEEVE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/brass_sleeve")
    public static final ItemTechMetal BRASS_SLEEVE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="metal/steel_sleeve")
    public static final ItemTechMetal STEEL_SLEEVE = (ItemTechMetal)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="ceramics/unfired/rackwheel_piece")
    public static final ItemPottery UNFIRED_RACKWHEEL_PIECE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/mold/rackwheel_piece")
    public static final ItemTechMold MOLD_RACKWHEEL_PIECE = (ItemTechMold)((Object)Helpers.getNull());
    @GameRegistry.ObjectHolder(value="ceramics/unfired/sleeve")
    public static final ItemPottery UNFIRED_SLEEVE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/mold/sleeve")
    public static final ItemTechMold MOLD_SLEEVE = (ItemTechMold)((Object)Helpers.getNull());
    private static ImmutableList<Item> allSimpleItems;
    private static ImmutableList<Item> allMetalItems;
    private static ImmutableList<Item> allCeramicMoldItems;

    public static ImmutableList<Item> getAllSimpleItems() {
        return allSimpleItems;
    }

    public static ImmutableList<Item> getAllMetalItems() {
        return allMetalItems;
    }

    public static ImmutableList<Item> getAllCeramicMoldItems() {
        return allCeramicMoldItems;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        ImmutableList.Builder simpleItems = ImmutableList.builder();
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "pot_ash", new ItemPottery(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "pot_potash", new ItemPottery(){

            @Nonnull
            public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
                return new ItemStack((Item)ItemsTFC.FIRED_POT);
            }

            public boolean hasContainerItem(@Nonnull ItemStack stack) {
                return true;
            }
        }, CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "powder/potash", new ItemMiscTech(Size.SMALL, Weight.LIGHT, "dustPotash"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "powder/lime", new ItemMiscHeatable(Size.SMALL, Weight.LIGHT, 0.22f, 2000.0f, "dustLime"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "powder/wood", new ItemMiscHeatable(Size.SMALL, Weight.LIGHT, 0.22f, 2000.0f, "dustWood"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "powder/ash", new ItemMiscHeatable(Size.SMALL, Weight.LIGHT, 0.22f, 2000.0f, "dustAsh"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "latex/vulcanizing_agents", new ItemMiscTech(Size.SMALL, Weight.LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "latex/rubber_mix", new ItemMiscHeatable(Size.SMALL, Weight.LIGHT, 0.8f, 800.0f), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "latex/rubber", new ItemMiscHeatable(Size.SMALL, Weight.LIGHT, 0.8f, 800.0f, "rubber"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "wiredraw/leather_belt", new ItemMiscTech(Size.NORMAL, Weight.LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "wiredraw/winch", new ItemMiscTech(Size.NORMAL, Weight.MEDIUM), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/unfired/sleeve", new ItemPottery(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/unfired/rackwheel_piece", new ItemPottery(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/unfired/glass_block", new ItemPottery(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/unfired/glass_pane", new ItemPottery(), CreativeTabsTFC.CT_MISC));
        allSimpleItems = simpleItems.build();
        ImmutableList.Builder ceramicItems = ImmutableList.builder();
        ceramicItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/mold/glass_block", new ItemGlassMolder(1000), CreativeTabsTFC.CT_MISC));
        ceramicItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/mold/glass_pane", new ItemGlassMolder(375), CreativeTabsTFC.CT_MISC));
        ceramicItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/mold/rackwheel_piece", new ItemTechMold(ItemTechMetal.ItemType.RACKWHEEL_PIECE), CreativeTabsTFC.CT_MISC));
        ItemTechMold sleeveMold = new ItemTechMold(ItemTechMetal.ItemType.SLEEVE){

            @Override
            public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
                return new ItemTechMold.FilledMoldCapability(nbt){

                    @Override
                    public int fill(FluidStack resource, boolean doFill) {
                        Metal metal;
                        if (resource != null && this.isValidMetal(metal = FluidsTFC.getMetalFromFluid((Fluid)resource.getFluid()))) {
                            return super.fill(resource, doFill);
                        }
                        return 0;
                    }

                    private boolean isValidMetal(@Nullable Metal metal) {
                        if (metal != null) {
                            return "tin".equals(metal.getRegistryName().func_110623_a()) || "brass".equals(metal.getRegistryName().func_110623_a()) || "steel".equals(metal.getRegistryName().func_110623_a());
                        }
                        return false;
                    }
                };
            }
        };
        ceramicItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "ceramics/mold/sleeve", sleeveMold, CreativeTabsTFC.CT_MISC));
        allCeramicMoldItems = ceramicItems.build();
        ImmutableList.Builder metalItems = ImmutableList.builder();
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/iron_groove", ItemTechMetal.ItemType.create(Metal.WROUGHT_IRON, ItemTechMetal.ItemType.GROOVE), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/iron_bowl_mount", ItemTechMetal.ItemType.create(Metal.WROUGHT_IRON, ItemTechMetal.ItemType.BOWL_MOUNT), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/iron_draw_plate", ItemTechMetal.ItemType.create(Metal.WROUGHT_IRON, ItemTechMetal.ItemType.DRAW_PLATE).func_77656_e(ToolMaterialsTFC.WROUGHT_IRON.func_77997_a()).func_77625_d(1), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/steel_draw_plate", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "steel")), ItemTechMetal.ItemType.DRAW_PLATE).func_77656_e(ToolMaterialsTFC.STEEL.func_77997_a()).func_77625_d(1), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/black_steel_draw_plate", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "black_steel")), ItemTechMetal.ItemType.DRAW_PLATE).func_77656_e(ToolMaterialsTFC.BLACK_STEEL.func_77997_a()).func_77625_d(1), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/iron_tongs", ItemTechMetal.ItemType.create(Metal.WROUGHT_IRON, ItemTechMetal.ItemType.TONGS).func_77625_d(1), CreativeTabsTFC.CT_MISC));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/copper_inductor", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "copper")), ItemTechMetal.ItemType.INDUCTOR), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/tin_sleeve", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "tin")), ItemTechMetal.ItemType.SLEEVE), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/brass_sleeve", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "brass")), ItemTechMetal.ItemType.SLEEVE), CreativeTabsTFC.CT_METAL));
        metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/steel_sleeve", ItemTechMetal.ItemType.create((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "steel")), ItemTechMetal.ItemType.SLEEVE), CreativeTabsTFC.CT_METAL));
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(false)) continue;
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_strip", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.STRIP), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_rackwheel_piece", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.RACKWHEEL_PIECE), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_rackwheel", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.RACKWHEEL), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_gear", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.GEAR), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_wire", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.WIRE), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_long_rod", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.LONG_ROD), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_rod", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.ROD), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_bolt", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.BOLT), CreativeTabsTFC.CT_METAL));
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_screw", ItemTechMetal.ItemType.create(metal, ItemTechMetal.ItemType.SCREW), CreativeTabsTFC.CT_METAL));
            if (!metal.getTier().isAtLeast(Metal.Tier.TIER_III) || metal.getToolMetal() == null) continue;
            metalItems.add((Object)TechItems.register((IForgeRegistry<Item>)r, "metal/" + metal.getRegistryName().func_110623_a().toLowerCase() + "_blowpipe", new ItemBlowpipe(metal), CreativeTabsTFC.CT_METAL));
        }
        allMetalItems = metalItems.build();
        TechItems.register((IForgeRegistry<Item>)r, "ceramics/fluid_bowl", new ItemFluidBowl(), CreativeTabsTFC.CT_POTTERY);
        TechBlocks.getAllInventoryItemBlocks().forEach(x -> TechItems.registerItemBlock((IForgeRegistry<Item>)r, x));
        TechBlocks.getAllTEISRBlocks().forEach(x -> TechItems.registerItemBlock((IForgeRegistry<Item>)r, x));
        for (Item metalItem : allMetalItems) {
            if (metalItem instanceof ItemTechMetal) {
                ItemTechMetal techMetal = (ItemTechMetal)metalItem;
                if (techMetal.getType() == ItemTechMetal.ItemType.ROD) {
                    OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"stick", techMetal.getMetal(ItemStack.field_190927_a)}), (ItemStack)new ItemStack(metalItem, 1, 0));
                    continue;
                }
                if (techMetal.getType() == ItemTechMetal.ItemType.LONG_ROD) {
                    OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"stick", "long", techMetal.getMetal(ItemStack.field_190927_a)}), (ItemStack)new ItemStack(metalItem, 1, 0));
                    continue;
                }
                OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{techMetal.getType(), techMetal.getMetal(ItemStack.field_190927_a)}), (ItemStack)new ItemStack(metalItem, 1, 0));
                continue;
            }
            Metal metal = ((IMetalItem)metalItem).getMetal(ItemStack.field_190927_a);
            OreDictionary.registerOre((String)OreDictionaryHelper.toString((Object[])new Object[]{"blowpipe"}), (ItemStack)new ItemStack(metalItem, 1, 0));
        }
        for (Item item : allSimpleItems) {
            if (!(item instanceof ItemMiscTech) || ((ItemMiscTech)item).getOreDictionary() == null) continue;
            OreDictionary.registerOre((String)((ItemMiscTech)item).getOreDictionary(), (Item)item);
        }
        TechItems.registerTFCOreDict();
    }

    private static void registerTFCOreDict() {
        BlocksTFC.getAllBlockRockVariants().forEach(x -> {
            if (x.getType() == Rock.Type.SAND && TechItems.isSilica(x)) {
                OreDictionary.registerOre((String)"sandSilica", (Block)x);
            }
        });
    }

    private static boolean isSilica(BlockRockVariant block) {
        String rockName = block.getRock().getRegistryName().func_110623_a().toLowerCase();
        return rockName.equalsIgnoreCase("chert") || rockName.equalsIgnoreCase("granite") || rockName.equalsIgnoreCase("quartzite") || rockName.equalsIgnoreCase("rhyolite") || rockName.equalsIgnoreCase("phyllite");
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(block.getRegistryName());
        return itemBlock;
    }

    private static void registerItemBlock(IForgeRegistry<Item> r, ItemBlock item) {
        item.setRegistryName(item.func_179223_d().getRegistryName());
        item.func_77637_a(item.func_179223_d().func_149708_J());
        r.register((IForgeRegistryEntry)item);
    }

    private static <T extends Item> T register(IForgeRegistry<Item> r, String name, T item, CreativeTabs ct) {
        item.setRegistryName("tfctech", name);
        item.func_77655_b("tfctech." + name.replace('/', '.'));
        item.func_77637_a(ct);
        r.register(item);
        return item;
    }
}

