/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.fluids;

import com.google.common.collect.HashBiMap;
import javax.annotation.Nonnull;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class TechFluids {
    private static final ResourceLocation LAVA_STILL = new ResourceLocation("tfc", "blocks/lava_still");
    private static final ResourceLocation LAVA_FLOW = new ResourceLocation("tfc", "blocks/lava_flow");
    private static final HashBiMap<Fluid, FluidWrapper> WRAPPERS = HashBiMap.create();
    public static FluidWrapper LATEX;
    public static FluidWrapper GLASS;

    public static void registerFluids() {
        LATEX = TechFluids.registerFluid(new Fluid("latex", LAVA_STILL, LAVA_FLOW, -460552));
        GLASS = TechFluids.registerFluid(new Fluid("glass", LAVA_STILL, LAVA_FLOW, -1206347));
        TechFluids.setFluidTemperatures();
    }

    private static void setFluidTemperatures() {
        GLASS.get().setTemperature(1073);
    }

    private static FluidWrapper registerFluid(@Nonnull Fluid newFluid) {
        boolean isDefault = FluidRegistry.registerFluid((Fluid)newFluid);
        if (!isDefault) {
            newFluid = FluidRegistry.getFluid((String)newFluid.getName());
        }
        FluidRegistry.addBucketForFluid((Fluid)newFluid);
        FluidWrapper properties = new FluidWrapper(newFluid, isDefault);
        WRAPPERS.put((Object)newFluid, (Object)properties);
        return properties;
    }
}

