/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.objects.container.IButtonHandler;
import net.dries007.tfc.objects.inventory.slot.SlotKnappingOutput;
import net.dries007.tfc.util.SimpleCraftMatrix;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.objects.items.glassworking.ItemGlassMolder;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ContainerGlassworking
extends Container
implements IButtonHandler {
    private final SimpleCraftMatrix matrix;
    private final ItemStack stack;
    private final EntityPlayer player;
    private final int itemDragIndex;
    private final boolean isOffhand;
    private int itemIndex;
    private boolean requiresReset;

    public ContainerGlassworking(InventoryPlayer playerInv, ItemStack stack) {
        this.player = playerInv.field_70458_d;
        this.stack = stack;
        this.itemDragIndex = playerInv.field_70461_c;
        if (stack == this.player.func_184614_ca()) {
            this.itemIndex = playerInv.field_70461_c + 27;
            this.isOffhand = false;
        } else {
            this.itemIndex = -100;
            this.isOffhand = true;
        }
        this.addContainerSlots();
        this.addPlayerInventorySlots(playerInv);
        ++this.itemIndex;
        this.matrix = new SimpleCraftMatrix();
        this.requiresReset = true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            if (index == this.itemIndex) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack1 = slot.func_75211_c();
            ItemStack itemstack = itemstack1.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(itemstack1, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotID, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotID == this.itemIndex && (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP || clickType == ClickType.THROW || clickType == ClickType.SWAP)) {
            return ItemStack.field_190927_a;
        }
        return dragType == this.itemDragIndex && clickType == ClickType.SWAP ? ItemStack.field_190927_a : super.func_184996_a(slotID, dragType, clickType, player);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void onButtonPress(int buttonID, @Nullable NBTTagCompound nbtTagCompound) {
        this.setSlotState(buttonID, false);
        Slot slot = (Slot)this.field_75151_b.get(0);
        if (slot != null) {
            GlassworkingRecipe recipe = GlassworkingRecipe.get(this.matrix);
            if (recipe != null) {
                slot.func_75215_d(recipe.getOutput());
            } else {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        }
    }

    public boolean requiresReset() {
        return this.requiresReset;
    }

    public void setRequiresReset(boolean value) {
        this.requiresReset = value;
    }

    public boolean getSlotState(int index) {
        return this.matrix.get(index);
    }

    public void setSlotState(int index, boolean value) {
        this.matrix.set(index, value);
        if (!this.canWork()) {
            this.matrix.setAll(false);
        }
    }

    public boolean isSolidified() {
        IItemHeat capHeat = (IItemHeat)this.stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        return capHeat instanceof ItemGlassMolder.GlassMolderCapability && ((ItemGlassMolder.GlassMolderCapability)capHeat).isSolidified();
    }

    public boolean canWork() {
        IItemHeat capHeat = (IItemHeat)this.stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        return capHeat instanceof ItemGlassMolder.GlassMolderCapability && ((ItemGlassMolder.GlassMolderCapability)capHeat).canWork();
    }

    private void addContainerSlots() {
        this.func_75146_a((Slot)new SlotKnappingOutput((IItemHandler)new ItemStackHandler(1), 0, 128, 44, this::finishCraft));
    }

    private void finishCraft() {
        this.matrix.setAll(false);
        this.requiresReset = true;
        ItemStack emptyBlowpipe = this.stack;
        IFluidHandlerItem cap = (IFluidHandlerItem)emptyBlowpipe.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap instanceof ItemGlassMolder.GlassMolderCapability) {
            ((ItemGlassMolder.GlassMolderCapability)cap).empty();
        }
        emptyBlowpipe.func_96631_a(1, Constants.RNG, null);
        if (emptyBlowpipe.func_77952_i() >= emptyBlowpipe.func_77958_k()) {
            emptyBlowpipe = ItemStack.field_190927_a;
        }
        if (this.isOffhand) {
            this.player.func_184611_a(EnumHand.OFF_HAND, emptyBlowpipe);
        } else {
            this.player.func_184611_a(EnumHand.MAIN_HAND, emptyBlowpipe);
        }
    }

    private void addPlayerInventorySlots(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 160));
        }
    }
}

