/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.blocks.devices;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.util.IBellowsConsumerBlock;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.client.TechGuiHandler;
import tfctech.objects.blocks.devices.BlockSmelteryCauldron;
import tfctech.objects.tileentities.TESmelteryFirebox;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockSmelteryFirebox
extends BlockHorizontal
implements IBellowsConsumerBlock,
ILightableBlock,
IItemSize {
    public BlockSmelteryFirebox() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149675_a(true);
        this.func_149715_a(1.0f);
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.LARGE;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta / 4 % 2 != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rng) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        if (rng.nextInt(24) == 0) {
            world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rng.nextFloat(), rng.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rng.nextFloat() < 0.4f) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.35;
            double z = (double)pos.func_177952_p() + 0.5;
            switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
                case NORTH: {
                    z -= (double)0.6f;
                    break;
                }
                case SOUTH: {
                    z += (double)0.6f;
                    break;
                }
                case WEST: {
                    x += (double)0.6f;
                    break;
                }
                case EAST: {
                    x += (double)0.6f;
                }
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.2, 0.0, new int[0]);
            if ((double)rng.nextFloat() > 0.75) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, x, y, z, 0.0, 0.1, 0.0, new int[0]);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TESmelteryFirebox te = (TESmelteryFirebox)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TESmelteryFirebox.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack held = player.func_184586_b(hand);
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockSmelteryCauldron) {
                    TESmelteryFirebox firebox = (TESmelteryFirebox)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryFirebox.class);
                    if (ItemFireStarter.canIgnite((ItemStack)held) && firebox.onIgnite()) {
                        ItemFireStarter.onIgnition((ItemStack)held);
                    } else {
                        TechGuiHandler.openGui(world, pos, player, TechGuiHandler.Type.SMELTERY_FIREBOX);
                    }
                } else if (held.func_77973_b() instanceof ItemBlock && ((ItemBlock)held.func_77973_b()).func_179223_d() instanceof BlockSmelteryCauldron && world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) {
                    held.func_77973_b().func_180614_a(player, world, pos.func_177984_a(), hand, side, hitX, hitY, hitZ);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.tfctech.smeltery.invalid", new Object[0]), true);
                }
            }
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT, field_185512_D});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TESmelteryFirebox();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean canIntakeFrom(@Nonnull TEBellows teBellows, @Nonnull Vec3i offset, @Nonnull EnumFacing direction) {
        return offset.equals((Object)TEBellows.OFFSET_LEVEL);
    }

    public void onAirIntake(@Nonnull TEBellows teBellows, @Nonnull World world, @Nonnull BlockPos pos, int airAmount) {
        TESmelteryFirebox firebox = (TESmelteryFirebox)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryFirebox.class);
        if (firebox != null) {
            firebox.onAirIntake(airAmount);
        }
    }
}

