/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.blocks.devices;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.client.TechSounds;
import tfctech.objects.tileentities.TELatexExtractor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockLatexExtractor
extends Block {
    public static final PropertyBool BASE = PropertyBool.func_177716_a((String)"base");
    public static final PropertyBool POT = PropertyBool.func_177716_a((String)"pot");
    public static final PropertyInteger CUT = PropertyInteger.func_177719_a((String)"cut", (int)0, (int)2);
    private static final AxisAlignedBB AABB_N = new AxisAlignedBB(0.1875, 0.125, 0.3125, 0.8125, 0.875, 1.0);
    private static final AxisAlignedBB AABB_S = new AxisAlignedBB(0.1875, 0.125, 0.0, 0.8125, 0.875, 0.6875);
    private static final AxisAlignedBB AABB_E = new AxisAlignedBB(0.0, 0.125, 0.1875, 0.6875, 0.875, 0.8125);
    private static final AxisAlignedBB AABB_W = new AxisAlignedBB(0.3125, 0.125, 0.1875, 1.0, 0.875, 0.8125);

    public BlockLatexExtractor() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CUT, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TELatexExtractor te = (TELatexExtractor)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TELatexExtractor.class);
        if (te != null) {
            return state.func_177226_a((IProperty)BASE, (Comparable)Boolean.valueOf(te.hasBase())).func_177226_a((IProperty)POT, (Comparable)Boolean.valueOf(te.hasPot())).func_177226_a((IProperty)CUT, (Comparable)Integer.valueOf(te.cutState()));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: {
                return AABB_N;
            }
            case SOUTH: {
                return AABB_S;
            }
            case EAST: {
                return AABB_E;
            }
            case WEST: {
                return AABB_W;
            }
        }
        return field_185505_j;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!(worldIn.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d())).func_177230_c() instanceof BlockLogTFC)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TELatexExtractor te = (TELatexExtractor)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TELatexExtractor.class);
        if (te != null) {
            if (te.cutState() > 0 && worldIn.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d())).func_177230_c() instanceof BlockLogTFC) {
                worldIn.func_175655_b(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176734_d()), true);
            }
            te.onBreakBlock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TELatexExtractor te = (TELatexExtractor)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TELatexExtractor.class);
        if (te != null && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77973_b().getHarvestLevel(stack, "knife", player, state) != -1) {
                if (te.makeCut()) {
                    world.func_184133_a(null, pos, TechSounds.RUBBER_TRUNK_SCRATH, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else {
                if (!te.hasPot() && te.isValidPot(stack) && te.addPot(stack)) {
                    stack.func_190918_g(1);
                    world.func_184133_a(null, pos, TechSounds.RUBBER_BOWL_FIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (!te.hasBase() && te.isValidBase(stack) && te.addBase(stack)) {
                    stack.func_190918_g(1);
                    world.func_184133_a(null, pos, TechSounds.RUBBER_MOUNT_FIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (stack.func_190926_b() && te.hasPot()) {
                    player.func_184611_a(hand, te.removePot());
                    world.func_184133_a(null, pos, TechSounds.RUBBER_BOWL_GRAB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                if (stack.func_190926_b() && te.hasBase()) {
                    player.func_184611_a(hand, te.removeBase());
                    world.func_184133_a(null, pos, TechSounds.RUBBER_GROOVE_FIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, BASE, POT, CUT});
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TELatexExtractor();
    }
}

