/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.blocks.devices;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.client.TechGuiHandler;
import tfctech.objects.tileentities.TEInductionCrucible;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockInductionCrucible
extends Block
implements IItemSize {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    private static final AxisAlignedBB CRUCIBLE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 0.125, 0.9375);
    private static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.1875);
    private static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0625, 0.0, 0.8125, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.1875, 0.9375, 0.9375);

    public BlockInductionCrucible() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta >= 4));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CRUCIBLE_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.BOWL;
        }
        return this.isSideSolid(state, worldIn, pos, face) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockInductionCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockInductionCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockInductionCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockInductionCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockInductionCrucible.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return CRUCIBLE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return CRUCIBLE_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (!world.field_72995_K) {
                TechGuiHandler.openGui(world, pos, player, TechGuiHandler.Type.INDUCTION_CRUCIBLE);
            }
            return true;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, LIT});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == baseState.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEInductionCrucible();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.LARGE;
    }

    public Weight getWeight(ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    public boolean canStack(ItemStack stack) {
        return false;
    }
}

