/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.blocks.devices;

import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.objects.tileentities.TEFridge;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockFridge
extends BlockHorizontal {
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.875);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 1.0, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final Vec3d[] ITEMS = new Vec3d[8];

    public static Vec3d[] getItems(EnumFacing facing) {
        Vec3d[] items = new Vec3d[8];
        for (int i = 0; i < 8; ++i) {
            Vec3d itemPos = ITEMS[i];
            if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                itemPos = itemPos.func_178785_b((float)Math.toRadians(90.0));
                itemPos = itemPos.func_72441_c(0.0, 0.0, 1.0);
            }
            items[i] = itemPos;
        }
        return items;
    }

    public static int getPlayerLookingItem(BlockPos bottomPos, EntityPlayer player, EnumFacing facing) {
        double length = Math.sqrt(bottomPos.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v)) + 0.7;
        Vec3d startPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d endPos = startPos.func_178787_e(new Vec3d(player.func_70040_Z().field_72450_a * length, player.func_70040_Z().field_72448_b * length, player.func_70040_Z().field_72449_c * length));
        Vec3d[] items = BlockFridge.getItems(facing);
        for (int i = 0; i < 8; ++i) {
            Vec3d itemPos = items[i];
            AxisAlignedBB offsetAABB = new AxisAlignedBB(itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c).func_186662_g(0.1).func_186670_a(bottomPos).func_186662_g(0.002);
            if (offsetAABB.func_72327_a(startPos, endPos) == null) continue;
            return i;
        }
        return -1;
    }

    public BlockFridge() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(meta > 3));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)UPPER) != false ? 4 : 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
            case NORTH: {
                return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? NORTH_AABB.func_186666_e(0.75) : NORTH_AABB;
            }
            case SOUTH: {
                return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? SOUTH_AABB.func_186666_e(0.75) : SOUTH_AABB;
            }
            case EAST: {
                return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? EAST_AABB.func_186666_e(0.75) : EAST_AABB;
            }
            case WEST: {
                return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? WEST_AABB.func_186666_e(0.75) : WEST_AABB;
            }
        }
        return NORTH_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                BlockFridge.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
            }
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEFridge te = (TEFridge)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TEFridge.class);
        if (te != null) {
            te.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)UPPER) != false ? Item.func_150898_a((Block)this) : Items.field_190931_a;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TEFridge te;
        BlockPos TEPos = pos;
        if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            TEPos = pos.func_177984_a();
        }
        if ((te = (TEFridge)Helpers.getTE((IBlockAccess)world, (BlockPos)TEPos, TEFridge.class)) == null || te.isAnimating() || hand != EnumHand.MAIN_HAND || facing != state.func_177229_b((IProperty)field_185512_D)) return false;
        if (te.isOpen()) {
            int slot = BlockFridge.getPlayerLookingItem(TEPos.func_177977_b(), player, facing);
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b()) {
                if (slot == -1) return false;
                if (world.field_72995_K) return true;
                player.func_184611_a(hand, te.insertItem(slot, stack));
                return true;
            }
            if (slot == -1 || !te.hasStack(slot)) return te.setOpening(false);
            if (world.field_72995_K) return true;
            player.func_184611_a(hand, te.extractItem(slot));
            return true;
        }
        if (player.func_70093_af()) return false;
        return te.setOpening(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, UPPER});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEFridge();
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    static {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 2; ++x) {
                double xPos = 0.7 - 0.4 * (double)x;
                double yPos = 0.55 + (double)y * 0.28125;
                double zPos = 0.5;
                BlockFridge.ITEMS[x + y * 2] = new Vec3d(xPos, yPos, zPos);
            }
        }
    }
}

