/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.blocks;

import com.google.common.collect.ImmutableList;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.blocks.BlockFluidTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import tfctech.objects.blocks.devices.BlockElectricForge;
import tfctech.objects.blocks.devices.BlockFridge;
import tfctech.objects.blocks.devices.BlockInductionCrucible;
import tfctech.objects.blocks.devices.BlockLatexExtractor;
import tfctech.objects.blocks.devices.BlockSmelteryCauldron;
import tfctech.objects.blocks.devices.BlockSmelteryFirebox;
import tfctech.objects.blocks.devices.BlockWireDrawBench;
import tfctech.objects.fluids.TechFluids;
import tfctech.objects.items.itemblocks.ItemBlockFridge;
import tfctech.objects.items.itemblocks.ItemBlockWireDrawBench;
import tfctech.objects.tileentities.TEElectricForge;
import tfctech.objects.tileentities.TEFridge;
import tfctech.objects.tileentities.TEInductionCrucible;
import tfctech.objects.tileentities.TELatexExtractor;
import tfctech.objects.tileentities.TESmelteryCauldron;
import tfctech.objects.tileentities.TESmelteryFirebox;
import tfctech.objects.tileentities.TEWireDrawBench;

@Mod.EventBusSubscriber(modid="tfctech")
@GameRegistry.ObjectHolder(value="tfctech")
public final class TechBlocks {
    public static final BlockElectricForge ELECTRIC_FORGE = (BlockElectricForge)((Object)Helpers.getNull());
    public static final BlockInductionCrucible INDUCTION_CRUCIBLE = (BlockInductionCrucible)((Object)Helpers.getNull());
    public static final BlockLatexExtractor LATEX_EXTRACTOR = (BlockLatexExtractor)((Object)Helpers.getNull());
    public static final BlockWireDrawBench WIRE_DRAW_BENCH = (BlockWireDrawBench)((Object)Helpers.getNull());
    public static final BlockFridge FRIDGE = (BlockFridge)((Object)Helpers.getNull());
    public static final BlockSmelteryCauldron SMELTERY_CAULDRON = (BlockSmelteryCauldron)((Object)Helpers.getNull());
    public static final BlockSmelteryFirebox SMELTERY_FIREBOX = (BlockSmelteryFirebox)((Object)Helpers.getNull());
    private static ImmutableList<ItemBlock> allInventoryItemBlocks;
    private static ImmutableList<ItemBlock> allTEISRBlocks;
    private static ImmutableList<BlockFluidBase> allFluidBlocks;

    public static ImmutableList<ItemBlock> getAllInventoryItemBlocks() {
        return allInventoryItemBlocks;
    }

    public static ImmutableList<ItemBlock> getAllTEISRBlocks() {
        return allTEISRBlocks;
    }

    public static ImmutableList<BlockFluidBase> getAllFluidBlocks() {
        return allFluidBlocks;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        TechFluids.registerFluids();
        ImmutableList.Builder b = ImmutableList.builder();
        if (TechFluids.LATEX.isDefault()) {
            b.add((Object)TechBlocks.register((IForgeRegistry<Block>)r, "fluid/" + TechFluids.LATEX.get().getName(), new BlockFluidTFC(TechFluids.LATEX.get(), Material.field_151586_h)));
        }
        allFluidBlocks = b.build();
        ImmutableList.Builder inventoryItemBlocks = ImmutableList.builder();
        inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)TechBlocks.register((IForgeRegistry<Block>)r, "electric_forge", new BlockElectricForge(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)TechBlocks.register((IForgeRegistry<Block>)r, "induction_crucible", new BlockInductionCrucible(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)TechBlocks.register((IForgeRegistry<Block>)r, "smeltery_cauldron", new BlockSmelteryCauldron(), CreativeTabsTFC.CT_MISC)));
        inventoryItemBlocks.add((Object)new ItemBlockTFC((Block)TechBlocks.register((IForgeRegistry<Block>)r, "smeltery_firebox", new BlockSmelteryFirebox(), CreativeTabsTFC.CT_MISC)));
        allInventoryItemBlocks = inventoryItemBlocks.build();
        ImmutableList.Builder teisrItemBlocks = ImmutableList.builder();
        teisrItemBlocks.add((Object)new ItemBlockWireDrawBench((Block)TechBlocks.register((IForgeRegistry<Block>)r, "wire_draw_bench", new BlockWireDrawBench(), CreativeTabsTFC.CT_MISC)));
        teisrItemBlocks.add((Object)new ItemBlockFridge((Block)TechBlocks.register((IForgeRegistry<Block>)r, "fridge", new BlockFridge(), CreativeTabsTFC.CT_MISC)));
        allTEISRBlocks = teisrItemBlocks.build();
        TechBlocks.register((IForgeRegistry<Block>)r, "latex_extractor", new BlockLatexExtractor());
        TechBlocks.register(TEElectricForge.class, "electric_forge");
        TechBlocks.register(TEInductionCrucible.class, "induction_crucible");
        TechBlocks.register(TELatexExtractor.class, "latex_extractor");
        TechBlocks.register(TEWireDrawBench.class, "wire_draw_bench");
        TechBlocks.register(TEFridge.class, "fridge");
        TechBlocks.register(TESmelteryCauldron.class, "smeltery_cauldron");
        TechBlocks.register(TESmelteryFirebox.class, "smeltery_firebox");
    }

    private static <T extends Block> T register(IForgeRegistry<Block> r, String name, T block, CreativeTabs ct) {
        block.func_149647_a(ct);
        return TechBlocks.register(r, name, block);
    }

    private static <T extends Block> T register(IForgeRegistry<Block> r, String name, T block) {
        block.setRegistryName("tfctech", name);
        block.func_149663_c("tfctech." + name.replace('/', '.'));
        r.register(block);
        return block;
    }

    private static <T extends TileEntity> void register(Class<T> te, String name) {
        TileEntity.func_190560_a((String)("tfctech:" + name), te);
    }
}

