/*
 * Decompiled with CFR 0.152.
 */
package tfctech.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.util.Helpers;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tfctech.objects.tileentities.TELatexExtractor;

public class PacketLatexUpdate
implements IMessage {
    private BlockPos pos;
    private int cutState = -1;
    private int fluid = 0;
    private boolean pot = false;
    private boolean base = false;

    @Deprecated
    public PacketLatexUpdate() {
    }

    public PacketLatexUpdate(@Nonnull TELatexExtractor tile) {
        this.pos = tile.func_174877_v();
        this.cutState = tile.cutState();
        this.fluid = tile.getFluidAmount();
        this.pot = tile.hasPot();
        this.base = tile.hasBase();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.cutState = buf.readInt();
        this.fluid = buf.readInt();
        this.pot = buf.readBoolean();
        this.base = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.cutState);
        buf.writeInt(this.fluid);
        buf.writeBoolean(this.pot);
        buf.writeBoolean(this.base);
    }

    public static class Handler
    implements IMessageHandler<PacketLatexUpdate, IMessage> {
        public IMessage onMessage(PacketLatexUpdate message, MessageContext ctx) {
            World world;
            TELatexExtractor te;
            EntityPlayer player = TerraFirmaCraft.getProxy().getPlayer(ctx);
            if (player != null && (te = (TELatexExtractor)Helpers.getTE((IBlockAccess)(world = player.func_130014_f_()), (BlockPos)message.pos, TELatexExtractor.class)) != null) {
                te.updateClient(message.cutState, message.fluid, message.pot, message.base);
            }
            return null;
        }
    }
}

