/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.jei.wrappers;

import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfctech.objects.items.ceramics.ItemTechMold;
import tfctech.objects.items.metal.ItemTechMetal;

public class UnmoldRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack mold;
    private final ItemStack output;

    public UnmoldRecipeWrapper(Metal metal, ItemTechMetal.ItemType type) {
        this.mold = new ItemStack((Item)ItemTechMold.get(type));
        IFluidHandler cap = (IFluidHandler)this.mold.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (cap instanceof IMoldHandler) {
            cap.fill(new FluidStack(FluidsTFC.getFluidFromMetal((Metal)metal), 100), true);
        }
        this.output = new ItemStack((Item)ItemTechMetal.get(metal, type));
    }

    public UnmoldRecipeWrapper(ItemStack inputMold, ItemStack output) {
        this.mold = inputMold;
        this.output = output;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.mold);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }
}

