/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.jei.wrappers;

import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import tfctech.api.recipes.SmelteryRecipe;

@ParametersAreNonnullByDefault
public class SmelteryRecipeWrapper
implements IRecipeWrapper {
    private final SmelteryRecipe recipe;

    public SmelteryRecipeWrapper(SmelteryRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<NonNullList> allInputs = new ArrayList<NonNullList>();
        for (IIngredient<ItemStack> ingredient : this.recipe.getIngredients()) {
            allInputs.add(ingredient.getValidIngredients());
        }
        ingredients.setInputLists(VanillaTypes.ITEM, allInputs);
        ArrayList<NonNullList> allOutputFluids = new ArrayList<NonNullList>();
        allOutputFluids.add(NonNullList.func_191197_a((int)1, (Object)this.recipe.getOutput()));
        ingredients.setOutputLists(VanillaTypes.FLUID, allOutputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float x = 44.0f;
        float y = 3.0f;
        String text = Heat.getTooltip((float)this.recipe.getMeltTemp());
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 0xFFFFFF, false);
    }
}

