/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.jei.wrappers;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.objects.fluids.TechFluids;

public class GlassworkingRecipeWrapper
implements IRecipeWrapper {
    private static final ResourceLocation GLASS_TEXTURE = new ResourceLocation("tfctech", "textures/gui/glassworking/button.png");
    private static final ResourceLocation GLASS_DISABLED_TEXTURE = new ResourceLocation("tfctech", "textures/gui/glassworking/disabled.png");
    protected final GlassworkingRecipe recipe;
    private final IDrawable squareHigh;
    private final IDrawable squareLow;

    public GlassworkingRecipeWrapper(GlassworkingRecipe recipe, IGuiHelper helper) {
        this.recipe = recipe;
        this.squareHigh = helper.drawableBuilder(GLASS_TEXTURE, 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.squareLow = helper.drawableBuilder(GLASS_DISABLED_TEXTURE, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack output = this.recipe.getOutput();
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(TechFluids.GLASS.get(), 250));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        for (int y = 0; y < this.recipe.getMatrix().getHeight(); ++y) {
            for (int x = 0; x < this.recipe.getMatrix().getWidth(); ++x) {
                if (this.recipe.getMatrix().get(x, y) && this.squareHigh != null) {
                    this.squareHigh.draw(minecraft, 1 + x * 16, 1 + y * 16);
                    continue;
                }
                if (this.squareLow == null) continue;
                this.squareLow.draw(minecraft, 1 + x * 16, 1 + y * 16);
            }
        }
    }
}

