/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.jei.wrappers.SimpleRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.client.gui.GuiGlassworking;
import tfctech.client.gui.GuiSmelteryCauldron;
import tfctech.compat.jei.categories.GlassworkingCategory;
import tfctech.compat.jei.categories.SmelteryCategory;
import tfctech.compat.jei.categories.WireDrawingCategory;
import tfctech.compat.jei.wrappers.CastingRecipeWrapper;
import tfctech.compat.jei.wrappers.GlassworkingRecipeWrapper;
import tfctech.compat.jei.wrappers.SmelteryRecipeWrapper;
import tfctech.compat.jei.wrappers.UnmoldRecipeWrapper;
import tfctech.objects.blocks.TechBlocks;
import tfctech.objects.fluids.TechFluids;
import tfctech.objects.items.TechItems;
import tfctech.objects.items.glassworking.ItemBlowpipe;
import tfctech.objects.items.metal.ItemTechMetal;
import tfctech.registry.TechRegistries;

@JEIPlugin
public class TechJEIPlugin
implements IModPlugin {
    private static final String WIRE_DRAWING_UID = "tfctech.wire_drawing";
    private static final String SMELTERY_UID = "tfctech.smeltery";
    private static final String GLASSWORKING_UID = "tfctech.glassworking";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new WireDrawingCategory(registry.getJeiHelpers().getGuiHelper(), WIRE_DRAWING_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SmelteryCategory(registry.getJeiHelpers().getGuiHelper(), SMELTERY_UID)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GlassworkingCategory(registry.getJeiHelpers().getGuiHelper(), GLASSWORKING_UID)});
    }

    public void register(IModRegistry registry) {
        List wireList = TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.getIngredients().size() == 2).map(SimpleRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(wireList, WIRE_DRAWING_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)TechBlocks.WIRE_DRAW_BENCH), new String[]{WIRE_DRAWING_UID});
        List glassList = TechRegistries.GLASSWORKING.getValuesCollection().stream().map(x -> new GlassworkingRecipeWrapper((GlassworkingRecipe)((Object)x), registry.getJeiHelpers().getGuiHelper())).collect(Collectors.toList());
        registry.addRecipes(glassList, GLASSWORKING_UID);
        TFCRegistries.METALS.getValuesCollection().forEach(metal -> {
            ItemBlowpipe blowpipe = ItemBlowpipe.get(metal);
            if (blowpipe != null) {
                registry.addRecipeCatalyst((Object)new ItemStack((Item)blowpipe), new String[]{GLASSWORKING_UID});
            }
        });
        List smelteryList = TechRegistries.SMELTERY.getValuesCollection().stream().map(SmelteryRecipeWrapper::new).collect(Collectors.toList());
        registry.addRecipes(smelteryList, SMELTERY_UID);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)TechBlocks.SMELTERY_CAULDRON), new String[]{SMELTERY_UID});
        registry.addRecipeClickArea(GuiSmelteryCauldron.class, 52, 58, 72, 15, new String[]{SMELTERY_UID});
        registry.addRecipeClickArea(GuiGlassworking.class, 132, 27, 9, 14, new String[]{GLASSWORKING_UID});
        registry.addIngredientInfo((Object)new ItemStack((Item)TechItems.WOOD_POWDER), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.wood_powder"});
        registry.addIngredientInfo((Object)new ItemStack((Item)TechItems.IRON_GROOVE), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.groove"});
        registry.addIngredientInfo((Object)new FluidStack(TechFluids.LATEX.get(), 1000), VanillaTypes.FLUID, new String[]{"jei.information.tfctech.latex"});
        registry.addIngredientInfo((Object)new ItemStack((Block)TechBlocks.FRIDGE), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.fridge"});
        registry.addIngredientInfo((Object)new ItemStack((Block)TechBlocks.WIRE_DRAW_BENCH), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.wiredraw"});
        registry.addIngredientInfo((Object)new ItemStack((Block)TechBlocks.INDUCTION_CRUCIBLE), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.crucible"});
        registry.addIngredientInfo((Object)new ItemStack((Block)TechBlocks.ELECTRIC_FORGE), VanillaTypes.ITEM, new String[]{"jei.information.tfctech.forge"});
        ArrayList<UnmoldRecipeWrapper> unmoldList = new ArrayList<UnmoldRecipeWrapper>();
        ArrayList castingList = new ArrayList();
        TFCRegistries.METALS.getValuesCollection().forEach(metal -> {
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(true)) {
                for (ItemTechMetal.ItemType type : ItemTechMetal.ItemType.values()) {
                    if (!type.hasMold() || ItemTechMetal.get(metal, type) == null) continue;
                    unmoldList.add(new UnmoldRecipeWrapper((Metal)metal, type));
                    castingList.add(new CastingRecipeWrapper((Metal)metal, type));
                }
            }
        });
        ItemStack input = new ItemStack((Item)TechItems.MOLD_BLOCK);
        IFluidHandlerItem cap = (IFluidHandlerItem)input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap != null) {
            cap.fill(new FluidStack(TechFluids.GLASS.get(), 1000), true);
        }
        unmoldList.add(new UnmoldRecipeWrapper(input, new ItemStack(Blocks.field_150359_w)));
        registry.addIngredientInfo((Object)input, VanillaTypes.ITEM, new String[]{"jei.information.tfctech.fill_mold"});
        input = new ItemStack((Item)TechItems.MOLD_PANE);
        cap = (IFluidHandlerItem)input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap != null) {
            cap.fill(new FluidStack(TechFluids.GLASS.get(), 375), true);
        }
        unmoldList.add(new UnmoldRecipeWrapper(input, new ItemStack(Blocks.field_150410_aZ)));
        registry.addIngredientInfo((Object)input, VanillaTypes.ITEM, new String[]{"jei.information.tfctech.fill_mold"});
        registry.addRecipes(unmoldList, "minecraft.crafting");
        registry.addRecipes(castingList, "tfc.casting");
    }
}

