/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tfctech.api.recipes.WireDrawingRecipe;
import tfctech.registry.TechRegistries;

@ZenClass(value="mods.tfctech.WireDrawing")
@ZenRegister
public class CTWireDrawing {
    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient input, int minTier, IItemStack output, int color) {
        if (output == null || input == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient ingredient = CTHelper.getInternalIngredient((crafttweaker.api.item.IIngredient)input);
        Metal.Tier tier = Metal.Tier.valueOf((int)minTier);
        final ItemStack outputItem = (ItemStack)output.getInternal();
        final WireDrawingRecipe recipe = new WireDrawingRecipe(new ResourceLocation(registryName), (IIngredient<ItemStack>)ingredient, tier, outputItem, color);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TechRegistries.WIRE_DRAWING.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding wire drawing recipe for " + outputItem.func_82833_r();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> ((ItemStack)x.getOutputs().get(0)).func_77969_a(item)).forEach(removeList::add);
        for (final WireDrawingRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.WIRE_DRAWING;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing wire drawing recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final WireDrawingRecipe recipe = (WireDrawingRecipe)TechRegistries.WIRE_DRAWING.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.WIRE_DRAWING;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing wire drawing recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

