/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tfctech.api.recipes.SmelteryRecipe;
import tfctech.registry.TechRegistries;

@ZenClass(value="mods.tfctech.Smeltery")
@ZenRegister
public class CTSmeltery {
    @ZenMethod
    public static CTSmelteryRecipeBuilder addRecipe(String registryName, ILiquidStack output, float meltTemp) {
        if (output == null) {
            throw new IllegalArgumentException("Output must be non-null");
        }
        FluidStack outputStack = (FluidStack)output.getInternal();
        return new CTSmelteryRecipeBuilder(new ResourceLocation(registryName), outputStack, meltTemp);
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        FluidStack fluid = (FluidStack)output.getInternal();
        List removeList = TechRegistries.SMELTERY.getValuesCollection().stream().filter(x -> x.getOutput().isFluidEqual(fluid)).collect(Collectors.toList());
        for (final SmelteryRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.SMELTERY;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing smeltery recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final SmelteryRecipe recipe = (SmelteryRecipe)TechRegistries.SMELTERY.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.SMELTERY;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing smeltery recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }

    @ZenClass(value="mods.tfctech.SmelteryRecipeBuilder")
    public static class CTSmelteryRecipeBuilder {
        private final SmelteryRecipe.Builder internal;
        private final ResourceLocation registryName;

        private CTSmelteryRecipeBuilder(ResourceLocation registryName, FluidStack fluidStack, float meltTemp) {
            this.registryName = registryName;
            this.internal = new SmelteryRecipe.Builder().setOutput(fluidStack, meltTemp);
        }

        @ZenMethod
        public CTSmelteryRecipeBuilder addInput(crafttweaker.api.item.IIngredient input) {
            if (input == null) {
                throw new IllegalArgumentException("Input must be non-null");
            }
            IIngredient ingredient = CTHelper.getInternalIngredient((crafttweaker.api.item.IIngredient)input);
            this.internal.addInput((IIngredient<ItemStack>)ingredient);
            return this;
        }

        @ZenMethod
        public void build() {
            final SmelteryRecipe recipe = this.internal.build();
            recipe.setRegistryName(this.registryName);
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    TechRegistries.SMELTERY.register((IForgeRegistryEntry)recipe);
                }

                public String describe() {
                    return "Adding smeltery recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

