/*
 * Decompiled with CFR 0.152.
 */
package tfctech.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.registry.TechRegistries;

@ZenClass(value="mods.tfctech.Glassworking")
@ZenRegister
public class CTGlassworking {
    @ZenMethod
    public static void addRecipe(String registryName, IItemStack output, String ... pattern) {
        if (output == null || pattern.length < 1 || pattern.length > 5) {
            throw new IllegalArgumentException("Output item must be non-null and pattern must be a closed interval [1, 5]");
        }
        ItemStack outputStack = (ItemStack)output.getInternal();
        final GlassworkingRecipe recipe = (GlassworkingRecipe)new GlassworkingRecipe(outputStack, pattern).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TechRegistries.GLASSWORKING.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding glassworking recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        List removeList = TechRegistries.GLASSWORKING.getValuesCollection().stream().filter(x -> x.getOutput().func_77969_a(item)).collect(Collectors.toList());
        for (final GlassworkingRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.GLASSWORKING;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing glassworking recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final GlassworkingRecipe recipe = (GlassworkingRecipe)TechRegistries.GLASSWORKING.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TechRegistries.GLASSWORKING;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing glassworking recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

