/*
 * Decompiled with CFR 0.152.
 */
package tfctech.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.client.FluidSpriteCache;
import net.dries007.tfc.objects.container.ContainerCrucible;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.client.gui.GuiElectricForge;
import tfctech.client.gui.GuiGlassworking;
import tfctech.client.gui.GuiInductionCrucible;
import tfctech.client.gui.GuiSmelteryCauldron;
import tfctech.client.gui.GuiSmelteryFirebox;
import tfctech.objects.container.ContainerElectricForge;
import tfctech.objects.container.ContainerGlassworking;
import tfctech.objects.container.ContainerSmelteryCauldron;
import tfctech.objects.container.ContainerSmelteryFirebox;
import tfctech.objects.items.glassworking.ItemBlowpipe;
import tfctech.objects.tileentities.TEElectricForge;
import tfctech.objects.tileentities.TEInductionCrucible;
import tfctech.objects.tileentities.TESmelteryCauldron;
import tfctech.objects.tileentities.TESmelteryFirebox;

public class TechGuiHandler
implements IGuiHandler {
    public static final ResourceLocation GUI_ELEMENTS = new ResourceLocation("tfctech", "textures/gui/elements.png");

    public static void openGui(World world, BlockPos pos, EntityPlayer player, Type type) {
        player.openGui((Object)TFCTech.getInstance(), type.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nullable
    public Container getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        ItemStack stack = player.func_184614_ca();
        Type type = Type.valueOf(ID);
        switch (type) {
            case ELECTRIC_FORGE: {
                TEElectricForge teElectricForge = (TEElectricForge)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TEElectricForge.class);
                return teElectricForge == null ? null : new ContainerElectricForge(player.field_71071_by, teElectricForge);
            }
            case INDUCTION_CRUCIBLE: {
                TEInductionCrucible teInductionCrucible = (TEInductionCrucible)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TEInductionCrucible.class);
                return teInductionCrucible == null ? null : new ContainerCrucible(player.field_71071_by, (TECrucible)teInductionCrucible);
            }
            case SMELTERY_CAULDRON: {
                TESmelteryCauldron teSmelteryCauldron = (TESmelteryCauldron)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryCauldron.class);
                return teSmelteryCauldron == null ? null : new ContainerSmelteryCauldron(player.field_71071_by, teSmelteryCauldron);
            }
            case SMELTERY_FIREBOX: {
                TESmelteryFirebox teSmelteryFirebox = (TESmelteryFirebox)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryFirebox.class);
                return teSmelteryFirebox == null ? null : new ContainerSmelteryFirebox(player.field_71071_by, teSmelteryFirebox);
            }
            case GLASSWORKING: {
                return new ContainerGlassworking(player.field_71071_by, stack.func_77973_b() instanceof ItemBlowpipe ? stack : player.func_184592_cb());
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Container container = this.getServerGuiElement(ID, player, world, x, y, z);
        Type type = Type.valueOf(ID);
        BlockPos pos = new BlockPos(x, y, z);
        switch (type) {
            case ELECTRIC_FORGE: {
                return new GuiElectricForge(container, player.field_71071_by, (TEElectricForge)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TEElectricForge.class));
            }
            case INDUCTION_CRUCIBLE: {
                return new GuiInductionCrucible(container, player.field_71071_by, (TEInductionCrucible)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TEInductionCrucible.class));
            }
            case SMELTERY_CAULDRON: {
                return new GuiSmelteryCauldron(container, player.field_71071_by, (TESmelteryCauldron)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryCauldron.class));
            }
            case SMELTERY_FIREBOX: {
                return new GuiSmelteryFirebox(container, player.field_71071_by, (TESmelteryFirebox)Helpers.getTE((IBlockAccess)world, (BlockPos)pos, TESmelteryFirebox.class));
            }
            case GLASSWORKING: {
                return new GuiGlassworking(container, player);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class Drawing {
        public static void drawTemperatureBar(Minecraft minecraft, Gui guiElement, int posX, int posY, float temperature) {
            minecraft.func_110434_K().func_110577_a(GUI_ELEMENTS);
            guiElement.func_73729_b(posX, posY, 39, 1, 9, 52);
            int temperaturePixels = (int)(51.0f * Math.min(Heat.maxVisibleTemperature(), temperature) / Heat.maxVisibleTemperature());
            guiElement.func_73729_b(posX - 3, posY + 49 - temperaturePixels, 36, 54, 15, 5);
        }

        public static void drawTank(Minecraft minecraft, Gui guiElement, int posX, int posY, int capacity, @Nullable FluidStack fluid) {
            minecraft.func_110434_K().func_110577_a(GUI_ELEMENTS);
            guiElement.func_73729_b(posX, posY, 0, 102, 18, 49);
            if (fluid != null) {
                int fillPixels = (int)Math.min(Math.ceil((float)fluid.amount / (float)capacity * 47.0f), 47.0);
                TextureAtlasSprite sprite = FluidSpriteCache.getStillSprite((Fluid)fluid.getFluid());
                minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int color = fluid.getFluid().getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                int startX = posX + 1;
                int startY = posY + 48 - fillPixels;
                int endX = posX + 17;
                int endY = posY + 48;
                buffer.func_181662_b((double)startX, (double)startY, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
                buffer.func_181662_b((double)startX, (double)endY, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)endX, (double)endY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
                buffer.func_181662_b((double)endX, (double)startY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                minecraft.field_71446_o.func_110577_a(GUI_ELEMENTS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiElement.func_73729_b(posX, posY, 18, 102, 18, 49);
            }
        }

        @Nullable
        public static List<String> getFluidTooltip(@Nullable FluidStack fluid, int mouseX, int mouseY, int posX, int posY) {
            if (fluid != null && mouseX >= posX && mouseX <= posX + 18 && mouseY >= posY && mouseY <= posY + 49) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(fluid.getLocalizedName());
                tooltip.add(fluid.amount + " / " + 4000);
                return tooltip;
            }
            return null;
        }
    }

    public static enum Type {
        ELECTRIC_FORGE,
        INDUCTION_CRUCIBLE,
        SMELTERY_CAULDRON,
        SMELTERY_FIREBOX,
        GLASSWORKING;

        private static final Type[] values;

        @Nonnull
        public static Type valueOf(int id) {
            while (id >= values.length) {
                id -= values.length;
            }
            while (id < 0) {
                id += values.length;
            }
            return values[id];
        }

        static {
            values = Type.values();
        }
    }
}

