/*
 * Decompiled with CFR 0.152.
 */
package tfctech.client;

import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.IMoldHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.client.render.teisr.TEISRTechDevices;
import tfctech.client.render.tesr.TESRFridge;
import tfctech.client.render.tesr.TESRLatexExtractor;
import tfctech.client.render.tesr.TESRWireDrawBench;
import tfctech.objects.blocks.TechBlocks;
import tfctech.objects.items.TechItems;
import tfctech.objects.items.glassworking.ItemBlowpipe;
import tfctech.objects.items.glassworking.ItemGlassMolder;
import tfctech.objects.items.metal.ItemGear;
import tfctech.objects.items.metal.ItemTechMetal;
import tfctech.objects.tileentities.TEFridge;
import tfctech.objects.tileentities.TELatexExtractor;
import tfctech.objects.tileentities.TEWireDrawBench;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tfctech")
public final class ClientRegisterEvents {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelResourceLocation EMPTY;
        ModelLoader.setCustomModelResourceLocation((Item)TechItems.FLUID_BOWL, (int)0, (ModelResourceLocation)new ModelResourceLocation(TechItems.FLUID_BOWL.getRegistryName(), "inventory"));
        for (Item item : TechItems.getAllSimpleItems()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString()));
        }
        for (Block block : TechBlocks.getAllFluidBlocks()) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFluidBase.LEVEL}).func_178441_a());
        }
        for (Item item : TechBlocks.getAllInventoryItemBlocks()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Item item : TechBlocks.getAllTEISRBlocks()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            item.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TEISRTechDevices());
        }
        for (Item item : TechItems.getAllMetalItems()) {
            if (item instanceof ItemTechMetal) {
                ItemTechMetal metalItem = (ItemTechMetal)item;
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("tfctech", "metal/" + metalItem.getType().name().toLowerCase()), "inventory"));
                if (((ItemTechMetal)item).getType() != ItemTechMetal.ItemType.WIRE) continue;
                for (int i = 1; i <= 4; ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("tfctech", "metal/" + metalItem.getType().name().toLowerCase()), "inventory"));
                }
                continue;
            }
            if (!(item instanceof ItemBlowpipe)) continue;
            EMPTY = new ModelResourceLocation(new ResourceLocation("tfctech", "metal/blowpipe_empty"), "inventory");
            final ModelResourceLocation FILLED = new ModelResourceLocation(new ResourceLocation("tfctech", "metal/blowpipe_filled"), "inventory");
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                @Nonnull
                public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                    FluidStack fluid;
                    IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (cap instanceof ItemGlassMolder.GlassMolderCapability && (fluid = ((ItemGlassMolder.GlassMolderCapability)cap).getFluid()) != null) {
                        return FILLED;
                    }
                    return EMPTY;
                }
            });
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{EMPTY, FILLED});
        }
        for (Item item : TechItems.getAllCeramicMoldItems()) {
            EMPTY = new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString() + "_empty"), "inventory");
            final ModelResourceLocation FILLED = new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString()), "inventory");
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                @Nonnull
                public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                    Metal metal;
                    FluidStack fluid;
                    IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    IFluidHandler moldCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (cap instanceof ItemGlassMolder.GlassMolderCapability ? (fluid = ((ItemGlassMolder.GlassMolderCapability)cap).getFluid()) != null : moldCap instanceof IMoldHandler && (metal = ((IMoldHandler)moldCap).getMetal()) != null) {
                        return FILLED;
                    }
                    return EMPTY;
                }
            });
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{EMPTY, FILLED});
        }
        ModelLoader.setCustomStateMapper((Block)TechBlocks.WIRE_DRAW_BENCH, (IStateMapper)new IStateMapper(){

            @Nonnull
            public Map<IBlockState, ModelResourceLocation> func_178130_a(@Nonnull Block blockIn) {
                return Collections.emptyMap();
            }
        });
        ModelLoader.setCustomStateMapper((Block)TechBlocks.FRIDGE, (IStateMapper)new IStateMapper(){

            @Nonnull
            public Map<IBlockState, ModelResourceLocation> func_178130_a(@Nonnull Block blockIn) {
                return Collections.emptyMap();
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TELatexExtractor.class, (TileEntitySpecialRenderer)new TESRLatexExtractor());
        ClientRegistry.bindTileEntitySpecialRenderer(TEWireDrawBench.class, (TileEntitySpecialRenderer)new TESRWireDrawBench());
        ClientRegistry.bindTileEntitySpecialRenderer(TEFridge.class, (TileEntitySpecialRenderer)new TESRFridge());
    }

    @SubscribeEvent
    public static void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        for (Item item : TechItems.getAllMetalItems()) {
            itemColors.func_186730_a((stack, tintIndex) -> {
                if (tintIndex == 1 && stack.func_77973_b() instanceof ItemGear) {
                    return new Color(((ItemGear)stack.func_77973_b()).getSleeveMetal().getColor()).brighter().getRGB();
                }
                if (tintIndex == 1 && stack.func_77973_b() instanceof ItemBlowpipe) {
                    FluidStack fluid;
                    IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (cap instanceof ItemGlassMolder.GlassMolderCapability && (fluid = ((ItemGlassMolder.GlassMolderCapability)cap).getFluid()) != null) {
                        return fluid.getFluid().getColor();
                    }
                    return -1;
                }
                return new Color(((IMetalItem)stack.func_77973_b()).getMetal(stack).getColor()).brighter().getRGB();
            }, new Item[]{item});
        }
        for (Item item : TechItems.getAllCeramicMoldItems()) {
            itemColors.func_186730_a((stack, tintIndex) -> {
                if (tintIndex == 1) {
                    IFluidHandlerItem cap;
                    IFluidHandler capFluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (capFluidHandler instanceof IMoldHandler) {
                        Metal metal = ((IMoldHandler)capFluidHandler).getMetal();
                        if (metal != null) {
                            return new Color(metal.getColor()).brighter().getRGB();
                        }
                    } else if (stack.func_77973_b() instanceof ItemGlassMolder && (cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) instanceof ItemGlassMolder.GlassMolderCapability && ((ItemGlassMolder.GlassMolderCapability)cap).getFluid() != null) {
                        FluidStack fluidStack = ((ItemGlassMolder.GlassMolderCapability)cap).getFluid();
                        return fluidStack.getFluid().getColor();
                    }
                    return -16777216;
                }
                return -1;
            }, new Item[]{item});
        }
    }
}

