/*
 * Decompiled with CFR 0.152.
 */
package tfctech.api.recipes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tfctech.registry.TechRegistries;

public class SmelteryRecipe
extends IForgeRegistryEntry.Impl<SmelteryRecipe> {
    private IIngredient<ItemStack>[] ingredients;
    private FluidStack outputFluid;
    private float meltTemp;

    @Nullable
    public static SmelteryRecipe get(ItemStack ... ingredients) {
        return TechRegistries.SMELTERY.getValuesCollection().stream().filter(x -> x.isValidInput(ingredients)).findFirst().orElse(null);
    }

    private SmelteryRecipe() {
    }

    public IIngredient<ItemStack>[] getIngredients() {
        return this.ingredients;
    }

    public FluidStack getOutput() {
        return this.outputFluid.copy();
    }

    public float getMeltTemp() {
        return this.meltTemp;
    }

    public void consumeInputs(List<ItemStack> inputs) {
        block0: for (IIngredient<ItemStack> ingredient : this.ingredients) {
            for (ItemStack stack : inputs) {
                if (!ingredient.test((Object)stack)) continue;
                stack.func_190918_g(ingredient.getAmount());
                continue block0;
            }
        }
    }

    private boolean isValidInput(ItemStack ... ingredients) {
        for (IIngredient<ItemStack> ingredient : this.ingredients) {
            boolean pass = false;
            for (ItemStack stack : ingredients) {
                if (!ingredient.test((Object)stack)) continue;
                pass = true;
                break;
            }
            if (pass) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ IIngredient[] access$302(SmelteryRecipe x0, IIngredient[] x1) {
        x0.ingredients = x1;
        return x1;
    }

    public static class Builder {
        private final SmelteryRecipe recipe = new SmelteryRecipe();
        private final List<IIngredient<ItemStack>> listInput = new ArrayList<IIngredient<ItemStack>>();

        public Builder addInput(@Nonnull IIngredient<ItemStack> ingredient) {
            if (this.listInput.size() >= 8) {
                throw new IllegalStateException("Smeltery recipes must have at most 8 ingredients!");
            }
            this.listInput.add(ingredient);
            return this;
        }

        public Builder setOutput(@Nonnull FluidStack fluidStack, float meltTemp) {
            this.recipe.outputFluid = fluidStack;
            this.recipe.meltTemp = meltTemp;
            return this;
        }

        public SmelteryRecipe build() {
            if (this.listInput.isEmpty()) {
                throw new IllegalStateException("Smeltery recipes must have at least 1 ingredient!");
            }
            if (this.recipe.outputFluid == null) {
                throw new IllegalStateException("Missing Smeltery recipe output!");
            }
            SmelteryRecipe.access$302(this.recipe, this.listInput.toArray(new IIngredient[0]));
            return this.recipe;
        }
    }
}

