/*
 * Decompiled with CFR 0.152.
 */
package tfctech;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tfctech", category="")
@Config.LangKey(value="config.tfctech")
@Mod.EventBusSubscriber(modid="tfctech")
public final class TechConfig {
    @Config.Comment(value={"Devices configuration"})
    @Config.LangKey(value="config.tfctech.devices")
    public static Devices DEVICES = new Devices();
    @Config.Comment(value={"Tweaks"})
    @Config.LangKey(value="config.tfctech.tweaks")
    public static Tweaks TWEAKS = new Tweaks();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tfctech")) {
            ConfigManager.sync((String)"tfctech", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Devices {
        @Config.Comment(value={"Should TFCTech machines accepts IC2 EU?"})
        @Config.LangKey(value="config.tfctech.devices.acceptIc2EU")
        public boolean acceptIc2EU = true;
        @Config.Comment(value={"How much energy 1 IC2 EU unit gives to machines?"})
        @Config.RangeInt(min=1)
        @Config.LangKey(value="config.tfctech.devices.ratioIc2")
        public int ratioIc2 = 4;
        @Config.Comment(value={"Should TFCTech machines accepts GTCE EU?"})
        @Config.LangKey(value="config.tfctech.devices.acceptIc2EU")
        public boolean acceptGTCEEU = true;
        @Config.Comment(value={"How much energy 1 GTCE EU unit gives to machines?"})
        @Config.RangeInt(min=1)
        @Config.LangKey(value="config.tfctech.devices.ratioGTCE")
        public int ratioGTCE = 4;
        @Config.Comment(value={"Which voltage tier machines should register to?"})
        @Config.RangeInt(min=1)
        @Config.LangKey(value="config.tfctech.devices.gtceVoltage")
        public int gtceVoltage = 32;
        @Config.Comment(value={"Modifier for how quickly electric forge heats items. Smaller number = slower temperature changes. Note: This is affected by TFC global modifier."})
        @Config.RangeDouble(min=0.01, max=1000.0)
        @Config.LangKey(value="config.tfctech.devices.electricForgeSpeed")
        public double electricForgeSpeed = 1.0;
        @Config.Comment(value={"The maximum heat obtainable by electric forge."})
        @Config.RangeDouble(min=500.0, max=5000.0)
        @Config.LangKey(value="config.tfctech.devices.electricForgeMaxTemperature")
        public double electricForgeMaxTemperature = 1601.0;
        @Config.Comment(value={"Electric forge energy consumption modifier."})
        @Config.RangeDouble(min=0.01, max=1000.0)
        @Config.LangKey(value="config.tfctech.devices.electricForgeEnergyConsumption")
        public double electricForgeEnergyConsumption = 1.0;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Electric forge energy capacity."})
        @Config.RangeInt(min=1000, max=1000000000)
        @Config.LangKey(value="config.tfctech.devices.electricForgeEnergyCapacity")
        public int electricForgeEnergyCapacity = 10000;
        @Config.Comment(value={"Induction crucible energy consumption, in RF/t."})
        @Config.RangeInt(min=1, max=1000000000)
        @Config.LangKey(value="config.tfctech.devices.inductionCrucibleEnergyConsumption")
        public int inductionCrucibleEnergyConsumption = 20;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Induction crucible energy capacity."})
        @Config.RangeInt(min=1000, max=1000000000)
        @Config.LangKey(value="config.tfctech.devices.inductionCrucibleEnergyCapacity")
        public int inductionCrucibleEnergyCapacity = 10000;
        @Config.Comment(value={"Fridge energy consumption modifier."})
        @Config.RangeDouble(min=0.01, max=1000.0)
        @Config.LangKey(value="config.tfctech.devices.fridgeEnergyConsumption")
        public double fridgeEnergyConsumption = 1.0;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Fridge energy capacity."})
        @Config.RangeInt(min=1000, max=1000000000)
        @Config.LangKey(value="config.tfctech.devices.fridgeEnergyCapacity")
        public int fridgeEnergyCapacity = 10000;
        @Config.Comment(value={"How fast fridges reach frozen state."})
        @Config.RangeDouble(min=0.01, max=1000.0)
        @Config.LangKey(value="config.tfctech.devices.fridgeEfficiency")
        public double fridgeEfficiency = 1.0;
        @Config.Comment(value={"How fast fridges lose efficiency when the door is open."})
        @Config.RangeDouble(min=0.01, max=1000.0)
        @Config.LangKey(value="config.tfctech.devices.fridgeLoseEfficiency")
        public double fridgeLoseEfficiency = 1.0;
    }

    public static class Tweaks {
        @Config.Comment(value={"Should TFCTech remove TFC and vanilla glass recipes?"})
        @Config.LangKey(value="config.tfctech.tweaks.removeGlassRecipes")
        public boolean removeGlassRecipes = true;
        @Config.Comment(value={"Which blocks are considered valid for rubber tapping?"})
        @Config.LangKey(value="config.tfctech.tweaks.validRubberTrees")
        public String[] rubberTrees = new String[]{"tfc:wood/log/hevea{placed=false,axis=y}", "dynamictreestfc:branch/hevea{radius=8}"};
    }
}

