/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tfctweaker;

import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class OredictTweak {
    public static void registerOredicts() {
        String name;
        for (Ore ore : TFCRegistries.ORES.getValuesCollection()) {
            name = OredictTweak.getName(ore.getRegistryName().func_110623_a());
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                OreDictionary.registerOre((String)("ore" + name), (ItemStack)new ItemStack((Block)BlockOreTFC.get((Ore)ore, (Rock)rock)));
                if (ore.getMetal() != null) {
                    OreDictionary.registerOre((String)name, (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.NORMAL, (int)1));
                    OreDictionary.registerOre((String)name, (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.RICH, (int)1));
                    OreDictionary.registerOre((String)name, (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.POOR, (int)1));
                    OreDictionary.registerOre((String)name, (ItemStack)ItemSmallOre.get((Ore)ore, (int)1));
                }
                OreDictionary.registerOre((String)("mineral" + name), (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.NORMAL, (int)1));
                OreDictionary.registerOre((String)("mineral" + name), (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.RICH, (int)1));
                OreDictionary.registerOre((String)("mineral" + name), (ItemStack)ItemOreTFC.get((Ore)ore, (Ore.Grade)Ore.Grade.POOR, (int)1));
            }
        }
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            name = OredictTweak.getName(rock);
            OreDictionary.registerOre((String)("stone" + name), (Block)BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.RAW));
            OreDictionary.registerOre((String)("stone" + OredictTweak.getCategory(rock)), (Block)BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.RAW));
            if (!rock.isFluxStone()) continue;
            OreDictionary.registerOre((String)"stoneFlux", (Block)BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.RAW));
        }
    }

    private static String getName(String ore) {
        StringBuilder result = new StringBuilder();
        if (ore.contains("_")) {
            String[] names = ore.toLowerCase().split("_");
            if (!names[0].contains("native")) {
                for (String name : names) {
                    result.append(StringUtils.capitalize((String)name));
                }
            } else {
                for (int i = names.length - 1; i >= 0; --i) {
                    result.append(StringUtils.capitalize((String)names[i]));
                }
            }
        } else {
            return StringUtils.capitalize((String)ore);
        }
        return result.toString();
    }

    private static String getName(Rock rock) {
        String ore = rock.getRegistryName().func_110623_a();
        StringBuilder result = new StringBuilder();
        if (ore.contains("_")) {
            String[] names;
            for (String name : names = ore.split("_")) {
                result.append(StringUtils.capitalize((String)name));
            }
        } else {
            return StringUtils.capitalize((String)ore);
        }
        return result.toString();
    }

    private static String getCategory(Rock rock) {
        String rockCategory = rock.getRockCategory().getRegistryName().func_110623_a();
        StringBuilder result = new StringBuilder();
        if (rockCategory.contains("_")) {
            String[] names;
            for (String name : names = rockCategory.split("_")) {
                result.append(StringUtils.capitalize((String)name));
            }
            return StringUtils.capitalize((String)result.toString());
        }
        return StringUtils.capitalize((String)rock.getRockCategory().getRegistryName().func_110623_a().toLowerCase());
    }
}

