/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.nethermetals.util;

import com.mcmoddev.lib.block.BlockExplosiveOre;
import com.mcmoddev.lib.block.BlockMMDNetherOre;
import com.mcmoddev.lib.events.MMDLibRegisterBlocks;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.util.Config;
import com.mcmoddev.lib.util.Oredicts;
import com.mcmoddev.nethermetals.init.NetherBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(value={Side.CLIENT, Side.SERVER}, modid="nethermetals")
public final class EventHandler {
    @SubscribeEvent
    public static void mmdlibRegisterBlocks(MMDLibRegisterBlocks event) {
        NetherBlocks.init();
    }

    @SubscribeEvent
    public static void onRemapBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals("nethermetals")) continue;
        }
    }

    @SubscribeEvent
    public static void onRemapItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals("nethermetals")) continue;
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Materials.getAllMaterials().stream().forEach(mat -> mat.getItems().stream().map(itemStack -> itemStack.func_77973_b()).filter(EventHandler::itemFilterFunc).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0)));
        Oredicts.registerItemOreDictionaryEntries();
        Oredicts.registerBlockOreDictionaryEntries();
    }

    private static boolean itemFilterFunc(Item item) {
        return EventHandler.matchModId(item.getRegistryName());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Materials.getAllMaterials().stream().forEach(mat -> mat.getBlocks().stream().filter(EventHandler::blockFilterFunc).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0)));
    }

    private static boolean blockFilterFunc(Block block) {
        return EventHandler.matchModId(block.getRegistryName());
    }

    private static boolean matchModId(ResourceLocation resourceLocation) {
        return resourceLocation.func_110624_b().equals("nethermetals");
    }

    public static void angerPigmen(BlockPos pos, World world, EntityPlayer player, int range) {
        int rr = range / 2;
        BlockPos work1 = new BlockPos((Vec3i)pos).func_177982_a(-rr, -rr, -rr);
        BlockPos work2 = new BlockPos((Vec3i)pos).func_177982_a(rr, rr, rr);
        AxisAlignedBB bb = new AxisAlignedBB(work1, work2);
        for (EntityLivingBase entity : world.func_72872_a(EntityPigZombie.class, bb)) {
            entity.func_70604_c((EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean silk = EventHandler.hasSilkTouch(event.getPlayer());
        int currentDimension = event.getWorld().field_73011_w.getDimension();
        Block targetBlock = event.getState().func_177230_c();
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (player != null && !player.func_184614_ca().func_190926_b() && !silk && currentDimension == -1 && EventHandler.isExplodingBlock(targetBlock)) {
            EventHandler.doExplode(event.getPos(), player, world);
        }
    }

    private static void doExplode(BlockPos pos, EntityPlayer player, World world) {
        int randomNum = new Random().nextInt(100) + 1;
        if (randomNum <= Config.Options.explosionChance() || Config.Options.explosionChance() > 100) {
            world.func_72876_a((Entity)player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.0f, true);
            if (Config.Options.angerPigmenRange() > 0) {
                EventHandler.angerPigmen(pos, world, player, Config.Options.angerPigmenRange());
            }
        }
    }

    private static boolean isExplodingBlock(Block targetBlock) {
        return targetBlock instanceof BlockMMDNetherOre && ((BlockExplosiveOre)targetBlock).doesExplode() || targetBlock.equals(Blocks.field_150449_bY);
    }

    private static boolean hasSilkTouch(EntityPlayer player) {
        if (player == null || player.func_184614_ca().func_190926_b()) {
            return false;
        }
        NBTTagList enchants = player.func_184614_ca().func_77986_q();
        if (enchants != null) {
            for (int index = 0; index < enchants.func_74745_c(); ++index) {
                short enchantId = enchants.func_150305_b(index).func_74765_d("id");
                if (Enchantment.func_185262_c((int)enchantId) == null || Enchantment.func_185262_c((int)enchantId) != Enchantments.field_185306_r) continue;
                return true;
            }
        }
        return false;
    }

    private EventHandler() {
        throw new IllegalAccessError("Not a instantiable class");
    }
}

