/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.vein;

import java.util.Random;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class VeinSphere
extends Vein {
    private final double radiusSq;

    VeinSphere(BlockPos pos, VeinType type, Ore.Grade grade, Random rand) {
        super(pos, type, grade);
        double innerRadius = (0.5 + 0.3 * rand.nextDouble()) * (double)type.getWidth();
        this.radiusSq = innerRadius * innerRadius;
    }

    @Override
    public double getChanceToGenerate(BlockPos pos) {
        double dist = this.pos.func_177951_i((Vec3i)pos) / this.radiusSq;
        if (dist < 0.8) {
            return this.type.getDensity();
        }
        if (dist < 1.0) {
            return this.type.getDensity() * (1.0 - dist) / 0.2;
        }
        return 0.0;
    }
}

