/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.vein;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.util.collections.WeightedCollection;
import net.dries007.tfc.world.classic.worldgen.WorldGenOreVeins;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;

public enum VeinRegistry {
    INSTANCE;

    private final WeightedCollection<VeinType> weightedVeinTypes = new WeightedCollection();
    private final Map<String, VeinType> veinTypeRegistry = new HashMap<String, VeinType>();

    @Nonnull
    public WeightedCollection<VeinType> getVeins() {
        return this.weightedVeinTypes;
    }

    @Nonnull
    public Set<String> keySet() {
        return this.veinTypeRegistry.keySet();
    }

    @Nullable
    public VeinType getVein(String name) {
        return this.veinTypeRegistry.get(name);
    }

    public void postInit() {
        int maxRadius = 0;
        for (VeinType type : this.veinTypeRegistry.values()) {
            if (type.getWidth() <= maxRadius) continue;
            maxRadius = type.getWidth();
        }
        WorldGenOreVeins.CHUNK_RADIUS = 1 + (maxRadius >> 4);
        TerraFirmaCraft.getLog().info("Vein Registry Initialized, with {} veins, {} max radius, {} total weight", (Object)this.veinTypeRegistry.size(), (Object)maxRadius, (Object)this.weightedVeinTypes.getTotalWeight());
    }

    public void readFile(Set<Map.Entry<String, JsonElement>> jsonElements, String subfolder) {
        for (Map.Entry<String, JsonElement> entry : jsonElements) {
            try {
                String properVeinName = entry.getKey();
                if ("#loader".equals(properVeinName)) continue;
                if (!subfolder.isEmpty()) {
                    properVeinName = subfolder + "/" + properVeinName;
                }
                VeinType vein = (VeinType)Constants.GSON.fromJson(entry.getValue(), VeinType.class);
                vein.setRegistryName(properVeinName);
                this.veinTypeRegistry.put(properVeinName, vein);
                this.weightedVeinTypes.add(vein.getWeight(), vein);
                TerraFirmaCraft.getLog().info("Registered new vein " + vein.toString());
            }
            catch (JsonParseException e) {
                TerraFirmaCraft.getLog().error("An ore vein is specified incorrectly! Skipping.");
                TerraFirmaCraft.getLog().error("Error: ", (Throwable)e);
            }
        }
    }
}

