/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.vein;

import javax.annotation.Nullable;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class Vein {
    protected final BlockPos pos;
    protected final VeinType type;
    protected final Ore.Grade grade;

    public static NBTTagCompound serialize(Vein vein) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("pos", vein.pos.func_177986_g());
        nbt.func_74774_a("grade", (byte)vein.grade.ordinal());
        if (vein.type != null) {
            nbt.func_74778_a("type", vein.type.getRegistryName());
        }
        return nbt;
    }

    public static Vein deserialize(NBTTagCompound nbt) {
        BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        Ore.Grade grade = Ore.Grade.valueOf(nbt.func_74771_c("grade"));
        VeinType type = VeinRegistry.INSTANCE.getVein(nbt.func_74779_i("type"));
        return new Vein(pos, type, grade);
    }

    Vein(BlockPos pos, VeinType type, Ore.Grade grade) {
        this.pos = pos;
        this.type = type;
        this.grade = grade;
    }

    public boolean inRange(int x, int z, int extraDistance) {
        return this.pos.func_177954_c((double)x, (double)this.pos.func_177956_o(), (double)z) < (double)((this.type.getWidth() + extraDistance) * (this.type.getWidth() + extraDistance));
    }

    public IBlockState getOreState(Rock rock) {
        return this.type.getOreState(rock, this.grade);
    }

    public boolean canSpawnIn(Rock rock) {
        return this.type.canSpawnIn(rock);
    }

    public int getLowestY() {
        return Math.max(this.pos.func_177956_o() - this.type.getHeight(), 1);
    }

    public int getHighestY() {
        return Math.min(this.pos.func_177956_o() + this.type.getHeight(), 255);
    }

    public double getChanceToGenerate(BlockPos pos) {
        return 0.0;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public VeinType getType() {
        return this.type;
    }

    public Ore.Grade getGrade() {
        return this.grade;
    }

    public int hashCode() {
        return this.pos.hashCode() * 3 + this.grade.ordinal();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vein) {
            Vein other = (Vein)obj;
            return other.pos.equals((Object)this.pos) && other.type == this.type && other.grade == this.grade;
        }
        return false;
    }
}

