/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Random;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenWillow
implements ITreeGenerator {
    private static final PlacementSettings settingsFull = StructureHelper.getDefaultSettings();
    private static final PlacementSettings settingsWeak = StructureHelper.getDefaultSettings().func_189946_a(0.5f);
    private Template structureBase;
    private Template structureOverlay;

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        int n;
        ResourceLocation base = new ResourceLocation("tfc", tree.getRegistryName().func_110623_a() + "/base");
        ResourceLocation overlay = new ResourceLocation("tfc", tree.getRegistryName().func_110623_a() + "/overlay");
        this.structureBase = manager.func_189942_b(world.func_73046_m(), base);
        this.structureOverlay = manager.func_189942_b(world.func_73046_m(), overlay);
        if (this.structureBase == null || this.structureOverlay == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString() + " or " + overlay.toString());
            return;
        }
        int height = 5 + rand.nextInt(3);
        int branches = 2 + rand.nextInt(3);
        for (n = 0; n <= height; ++n) {
            if (n > 3) {
                this.createLeafGroup(world, pos.func_177981_b(n));
            }
            this.tryPlaceLog(world, pos.func_177981_b(n), tree, BlockLog.EnumAxis.Y);
        }
        for (n = 0; n < branches; ++n) {
            int x1 = (rand.nextBoolean() ? 1 : -1) * (1 + rand.nextInt(3));
            int z1 = (rand.nextBoolean() ? 1 : -1) * (1 + rand.nextInt(3));
            int y1 = 3 + rand.nextInt(2);
            this.createLeafGroup(world, pos.func_177982_a(x1, y1, z1));
            this.createBranch(world, pos, x1, y1, z1, rand, tree);
        }
    }

    private void createBranch(World world, BlockPos pos1, int x, int y, int z, Random rand, Tree tree) {
        int z1;
        int x1 = x < 0 ? 1 : -1;
        int n = z1 = z < 0 ? 1 : -1;
        do {
            if (x != 0 && rand.nextBoolean()) {
                x += x1;
            }
            if (z != 0 && rand.nextBoolean()) {
                z += z1;
            }
            this.tryPlaceLog(world, pos1.func_177982_a(x, y, z), tree, BlockLog.EnumAxis.NONE);
            if (!rand.nextBoolean()) continue;
            this.createLeafGroup(world, pos1.func_177982_a(x, y, z));
        } while (Math.abs(x) + Math.abs(z) > 0);
    }

    private void createLeafGroup(World world, BlockPos pos) {
        BlockPos size = this.structureBase.func_186259_a();
        pos = pos.func_177982_a(-size.func_177958_n() / 2, -size.func_177956_o() / 2, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, this.structureBase, settingsFull);
        StructureHelper.addStructureToWorld(world, pos, this.structureOverlay, settingsWeak);
    }

    private void tryPlaceLog(World world, BlockPos pos, Tree tree, BlockLog.EnumAxis axis) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_180495_p(pos).func_177230_c() instanceof BlockSaplingTFC || world.func_180495_p(pos).func_177230_c() instanceof BlockLeavesTFC) {
            world.func_175656_a(pos, BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis).func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false)));
        }
    }
}

