/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Random;
import java.util.stream.IntStream;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenVariants
implements ITreeGenerator {
    private static final PlacementSettings settings = StructureHelper.getDefaultSettings();
    private final String[] variants;
    private final boolean useRotation;

    public TreeGenVariants(boolean useRotation, String ... variants) {
        this.variants = variants;
        this.useRotation = useRotation;
    }

    public TreeGenVariants(boolean useRotation, int numVariants) {
        this(useRotation, (String[])IntStream.range(1, numVariants + 1).mapToObj(String::valueOf).toArray(String[]::new));
    }

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        String variant = this.variants[this.variants.length == 1 ? 0 : rand.nextInt(this.variants.length)];
        ResourceLocation base = new ResourceLocation(tree.getRegistryName() + "/" + variant);
        Template structureBase = manager.func_189942_b(world.func_73046_m(), base);
        if (structureBase == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString());
            return;
        }
        PlacementSettings settings2 = this.useRotation ? StructureHelper.getRandomSettings(rand) : settings;
        BlockPos size = structureBase.func_186259_a().func_190942_a(settings2.func_186215_c());
        pos = pos.func_177982_a(-size.func_177958_n() / 2, 0, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, structureBase, settings2);
    }
}

