/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Random;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenNormal
implements ITreeGenerator {
    private static final PlacementSettings settingsFull = StructureHelper.getDefaultSettings();
    private static final PlacementSettings settingsWeak = StructureHelper.getDefaultSettings().func_189946_a(0.5f);
    private final int heightMin;
    private final int heightRange;

    public TreeGenNormal(int heightMin, int heightRange) {
        this.heightMin = heightMin;
        this.heightRange = heightRange;
    }

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        ResourceLocation base = new ResourceLocation(tree.getRegistryName() + "/base");
        ResourceLocation overlay = new ResourceLocation(tree.getRegistryName() + "/overlay");
        Template structureBase = manager.func_189942_b(world.func_73046_m(), base);
        Template structureOverlay = manager.func_189942_b(world.func_73046_m(), overlay);
        if (structureBase == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString());
            return;
        }
        int height = this.heightMin + (this.heightRange > 0 ? rand.nextInt(this.heightRange) : 0);
        BlockPos size = structureBase.func_186259_a();
        pos = pos.func_177982_a(-size.func_177958_n() / 2, height, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, structureBase, settingsFull);
        if (structureOverlay != null) {
            StructureHelper.addStructureToWorld(world, pos, structureOverlay, settingsWeak);
        }
        IBlockState log = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false));
        for (int i = 0; i < height; ++i) {
            world.func_175656_a(pos.func_177982_a(size.func_177958_n() / 2, i - height, size.func_177952_p() / 2), log);
        }
    }
}

