/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Random;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenKapok
implements ITreeGenerator {
    private static final PlacementSettings settings = StructureHelper.getDefaultSettings();
    private static final BlockPos[] trunkPos = new BlockPos[]{new BlockPos(0, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(-1, 0, -1)};
    private IBlockState trunk;
    private IBlockState bark;

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        int i;
        this.trunk = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false));
        this.bark = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        int height = 12 + rand.nextInt(8);
        int branches = 2 + rand.nextInt(3);
        for (i = 0; i < branches; ++i) {
            int y1 = 6 + rand.nextInt(height - 8);
            int x1 = rand.nextInt(3);
            int z1 = rand.nextInt(3);
            if (rand.nextBoolean()) {
                x1 = -x1 - 1;
            }
            if (rand.nextBoolean()) {
                x1 = -z1 - 1;
            }
            if (x1 == 0 || x1 == -1) {
                x1 = x1 * 3 + 1;
            }
            if (z1 == 0 || z1 == -1) {
                z1 = z1 * 3 + 1;
            }
            int type = 1 + rand.nextInt(3);
            this.placeBranch(manager, world, pos.func_177982_a(x1, y1, z1), tree.getRegistryName() + "/branch" + type);
            this.checkAndPlace(world, pos.func_177982_a(x1 - Math.abs(x1) / x1, y1 - 1, z1 - Math.abs(z1) / z1), true);
        }
        for (i = -1; i < height; ++i) {
            this.placeTrunk(world, pos.func_177982_a(0, i, 0));
        }
        this.placeBranch(manager, world, pos.func_177982_a(0, height, 0), tree.getRegistryName() + "/top");
    }

    @Override
    public boolean canGenerateTree(World world, BlockPos pos, Tree treeType) {
        for (BlockPos p1 : trunkPos) {
            if (BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1))) || world.func_180495_p(pos.func_177971_a((Vec3i)p1)).func_185904_a().func_76222_j() && (BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1).func_177979_c(1))) || BlocksTFC.isSoil(world.func_180495_p(pos.func_177971_a((Vec3i)p1).func_177979_c(2))) && world.func_180495_p(pos.func_177971_a((Vec3i)p1.func_177979_c(1))).func_185904_a().func_76222_j())) continue;
            return false;
        }
        return ITreeGenerator.super.canGenerateTree(world, pos, treeType);
    }

    private void placeBranch(TemplateManager manager, World world, BlockPos pos, String name) {
        ResourceLocation base = new ResourceLocation(name);
        Template structureBase = manager.func_189942_b(world.func_73046_m(), base);
        if (structureBase == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString());
            return;
        }
        BlockPos size = structureBase.func_186259_a();
        pos = pos.func_177982_a(-size.func_177958_n() / 2, 0, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, structureBase, settings);
    }

    private void placeTrunk(World world, BlockPos pos) {
        for (BlockPos p1 : trunkPos) {
            this.checkAndPlace(world, pos.func_177971_a((Vec3i)p1), false);
        }
        this.placeVine(world, pos.func_177982_a(1, 0, 0), BlockVine.field_176280_O);
        this.placeVine(world, pos.func_177982_a(1, 0, -1), BlockVine.field_176280_O);
        this.placeVine(world, pos.func_177982_a(0, 0, 1), BlockVine.field_176273_b);
        this.placeVine(world, pos.func_177982_a(-1, 0, 1), BlockVine.field_176273_b);
        this.placeVine(world, pos.func_177982_a(-2, 0, 0), BlockVine.field_176278_M);
        this.placeVine(world, pos.func_177982_a(-2, 0, -1), BlockVine.field_176278_M);
        this.placeVine(world, pos.func_177982_a(-1, 0, -2), BlockVine.field_176279_N);
        this.placeVine(world, pos.func_177982_a(0, 0, -2), BlockVine.field_176279_N);
    }

    private void checkAndPlace(World world, BlockPos pos, boolean useBark) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_180495_p(pos).func_177230_c() instanceof BlockSaplingTFC || world.func_180495_p(pos).func_177230_c() instanceof BlockLeavesTFC) {
            world.func_175656_a(pos, useBark ? this.bark : this.trunk);
        }
    }

    private void placeVine(World world, BlockPos pos, PropertyBool prop) {
        if (Math.random() < (double)0.8f && world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            world.func_175656_a(pos, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
        }
    }
}

