/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen.trees;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.wood.BlockLeavesTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.world.classic.StructureHelper;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TreeGenAcacia
implements ITreeGenerator {
    private static final PlacementSettings settings = StructureHelper.getDefaultSettings();
    private IBlockState trunk;
    private IBlockState bark;

    @Override
    public void generateTree(TemplateManager manager, World world, BlockPos pos, Tree tree, Random rand, boolean isWorldGen) {
        int i;
        this.trunk = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false));
        this.bark = BlockLogTFC.get(tree).func_176223_P().func_177226_a((IProperty)BlockLogTFC.PLACED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        boolean smallBranch = rand.nextBoolean();
        int branches = 2 + rand.nextInt(2);
        int height = 5 + rand.nextInt(4);
        List sides = Arrays.stream(EnumFacing.field_176754_o).collect(Collectors.toList());
        int y2 = 0;
        int y3 = 0;
        EnumFacing side = EnumFacing.UP;
        if (smallBranch) {
            y3 = rand.nextInt(3) + 2;
            side = (EnumFacing)sides.get(rand.nextInt(sides.size()));
            this.placeBranch(manager, world, pos.func_177972_a(side).func_177982_a(0, y3, 0), tree.getRegistryName() + "/branch3");
        }
        for (i = 0; i < branches; ++i) {
            int x1 = 2 + rand.nextInt(3);
            int y1 = 4 + rand.nextInt(height - 2);
            if (y1 > y2) {
                y2 = y1;
            }
            EnumFacing face = (EnumFacing)sides.remove(rand.nextInt(sides.size()));
            for (int j = 1; j < x1; ++j) {
                this.placeLog(world, pos.func_177982_a(0, y1 - j, 0).func_177967_a(face, x1 - j), true);
            }
            int branch = 1 + rand.nextInt(2);
            this.placeBranch(manager, world, pos.func_177982_a(0, y1, 0).func_177967_a(face, x1), tree.getRegistryName() + "/branch" + branch);
        }
        for (i = 0; i < height; ++i) {
            if (smallBranch && i == y3) {
                this.placeLog(world, pos.func_177982_a(0, i - 1, 0), true);
                pos = pos.func_177972_a(side.func_176734_d());
                this.placeLog(world, pos.func_177982_a(0, i, 0), true);
                continue;
            }
            this.placeLog(world, pos.func_177982_a(0, i, 0), false);
        }
        this.placeBranch(manager, world, pos.func_177982_a(0, height, 0), tree.getRegistryName() + "/branch3");
    }

    private void placeBranch(TemplateManager manager, World world, BlockPos pos, String name) {
        ResourceLocation base = new ResourceLocation(name);
        Template structureBase = manager.func_189942_b(world.func_73046_m(), base);
        if (structureBase == null) {
            TerraFirmaCraft.getLog().warn("Unable to find a template for " + base.toString());
            return;
        }
        BlockPos size = structureBase.func_186259_a();
        pos = pos.func_177982_a(-size.func_177958_n() / 2, 0, -size.func_177952_p() / 2);
        StructureHelper.addStructureToWorld(world, pos, structureBase, settings);
    }

    private void placeLog(World world, BlockPos pos, boolean useBark) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_180495_p(pos).func_177230_c() instanceof BlockSaplingTFC || world.func_180495_p(pos).func_177230_c() instanceof BlockLeavesTFC) {
            world.func_175656_a(pos, useBark ? this.bark : this.trunk);
        }
    }
}

