/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

@ParametersAreNonnullByDefault
public class WorldGenWildCrops
implements IWorldGenerator {
    private static final List<ICrop> CROPS = new ArrayList<ICrop>();

    public static void register(ICrop bush) {
        CROPS.add(bush);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof ChunkGenTFC && world.field_73011_w.getDimension() == 0 && CROPS.size() > 0 && ConfigTFC.General.FOOD.cropRarity > 0 && random.nextInt(ConfigTFC.General.FOOD.cropRarity) == 0) {
            BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            Collections.shuffle(CROPS);
            float temperature = ClimateTFC.getAvgTemp(world, chunkBlockPos);
            float rainfall = ChunkDataTFC.getRainfall(world, chunkBlockPos);
            ICrop crop = CROPS.stream().filter(x -> x.isValidConditions(temperature, rainfall)).findFirst().orElse(null);
            if (crop != null) {
                BlockCropTFC cropBlock = BlockCropTFC.get(crop);
                int cropsInChunk = 3 + random.nextInt(5);
                for (int i = 0; i < cropsInChunk; ++i) {
                    int maxStage;
                    int z;
                    int x2 = (chunkX << 4) + random.nextInt(16) + 8;
                    BlockPos pos = world.func_175672_r(new BlockPos(x2, 0, z = (chunkZ << 4) + random.nextInt(16) + 8));
                    if (!world.func_175623_d(pos) || !BlocksTFC.isSoil(world.func_180495_p(pos.func_177977_b()))) continue;
                    double yearProgress = (double)CalendarTFC.CALENDAR_TIME.getMonthOfYear().ordinal() / 11.0;
                    int growth = (int)(yearProgress * (double)(maxStage = crop.getMaxStage())) + 3 - random.nextInt(2);
                    if (growth > maxStage) {
                        growth = maxStage;
                    }
                    world.func_180501_a(pos, cropBlock.func_176223_P().func_177226_a((IProperty)cropBlock.getStageProperty(), (Comparable)Integer.valueOf(growth)).func_177226_a((IProperty)BlockCropTFC.WILD, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }
    }
}

