/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Random;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockSpike;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSpikes
implements IWorldGenerator {
    private final boolean ceiling;
    private final int rarity;

    public WorldGenSpikes(boolean ceiling, int rarity) {
        this.ceiling = ceiling;
        this.rarity = rarity;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        for (int k5 = 0; k5 < this.rarity; ++k5) {
            BlockPos freeSpace;
            int x = random.nextInt(16) + 8;
            int z = random.nextInt(16) + 8;
            int y = random.nextInt(94) + 30;
            BlockPos basePos = new BlockPos(chunkX << 4, y, chunkZ << 4).func_177982_a(x, 0, z);
            BlockPos topPos = this.ceiling ? basePos.func_177977_b() : basePos.func_177984_a();
            BlockPos stoneAttach = this.ceiling ? basePos.func_177984_a() : basePos.func_177977_b();
            BlockPos blockPos = freeSpace = this.ceiling ? topPos.func_177977_b() : topPos.func_177984_a();
            if (!BlocksTFC.isRawStone(world.func_180495_p(stoneAttach)) || !world.func_175623_d(basePos) || !world.func_175623_d(topPos) || !world.func_175623_d(freeSpace)) continue;
            boolean canPlace = true;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (world.func_175623_d(basePos.func_177972_a(facing)) && world.func_175623_d(topPos.func_177972_a(facing))) continue;
                canPlace = false;
                break;
            }
            if (!canPlace) continue;
            BlockRockRaw rockBlock = (BlockRockRaw)world.func_180495_p(stoneAttach).func_177230_c();
            IBlockState baseState = BlockRockVariant.get(rockBlock.getRock(), Rock.Type.SPIKE).func_176223_P().func_177226_a((IProperty)BlockRockSpike.BASE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRockSpike.CEILING, (Comparable)Boolean.valueOf(this.ceiling));
            IBlockState topState = BlockRockVariant.get(rockBlock.getRock(), Rock.Type.SPIKE).func_176223_P().func_177226_a((IProperty)BlockRockSpike.BASE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockRockSpike.CEILING, (Comparable)Boolean.valueOf(this.ceiling));
            world.func_180501_a(basePos, baseState, 2);
            world.func_180501_a(topPos, topState, 2);
        }
    }
}

