/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSoilPits
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkGenTFC)) {
            return;
        }
        BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        BlockPos pos = world.func_175672_r(chunkBlockPos.func_177982_a(8 + random.nextInt(16), 0, 8 + random.nextInt(16)));
        this.generateClay(world, random, pos);
        pos = world.func_175672_r(chunkBlockPos.func_177982_a(8 + random.nextInt(16), 0, 8 + random.nextInt(16)));
        this.generatePeat(world, random, pos);
    }

    private void generateClay(World world, Random rng, BlockPos start) {
        int radius = rng.nextInt(6) + 2;
        int depth = rng.nextInt(3) + 1;
        if (rng.nextInt(ConfigTFC.General.WORLD.clayRarity) != 0 || start.func_177956_o() > 150) {
            return;
        }
        if (ChunkDataTFC.getRainfall(world, start) < (float)ConfigTFC.General.WORLD.clayRainfallThreshold) {
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos posHorizontal = start.func_177982_a(x, 0, z);
                boolean flag = false;
                for (int y = -depth; y <= depth; ++y) {
                    BlockPos pos = posHorizontal.func_177982_a(0, y, 0);
                    IBlockState current = world.func_180495_p(pos);
                    if (BlocksTFC.isDirt(current)) {
                        world.func_180501_a(pos, BlockRockVariant.get(ChunkDataTFC.getRockHeight(world, pos), Rock.Type.CLAY).func_176223_P(), 2);
                        flag = true;
                        continue;
                    }
                    if (!BlocksTFC.isGrass(current)) continue;
                    world.func_180501_a(pos, BlockRockVariant.get(ChunkDataTFC.getRockHeight(world, pos), Rock.Type.CLAY_GRASS).func_176223_P(), 2);
                    flag = true;
                }
                if (!flag || rng.nextInt(15) != 0) continue;
                BlockPos pos = world.func_175672_r(posHorizontal);
                for (Plant plant : TFCRegistries.PLANTS.getValuesCollection()) {
                    if (!plant.getIsClayMarking()) continue;
                    BlockPlantTFC plantBlock = BlockPlantTFC.get(plant);
                    IBlockState state = plantBlock.func_176223_P();
                    int plantAge = plant.getAgeForWorldgen(rng, ClimateTFC.getActualTemp(world, pos));
                    if (world.field_73011_w.func_177495_o() || world.func_189509_E(pos) || !plant.isValidLocation(ClimateTFC.getActualTemp(world, pos), ChunkDataTFC.getRainfall(world, pos), world.func_175642_b(EnumSkyBlock.SKY, pos)) || !world.func_175623_d(pos) || !plantBlock.func_180671_f(world, pos, state)) continue;
                    world.func_180501_a(pos, state.func_177226_a((IProperty)BlockPlantTFC.AGE, (Comparable)Integer.valueOf(plantAge)), 2);
                }
            }
        }
    }

    private boolean generatePeat(World world, Random rng, BlockPos start) {
        int radius = rng.nextInt(4) + 4;
        int depth = 2;
        if (rng.nextInt(30) != 0 || start.func_177956_o() > 144) {
            return false;
        }
        ChunkDataTFC data = ChunkDataTFC.get(world, start);
        if (data.isInitialized() && data.getRainfall() >= 375.0f && data.getFloraDiversity() >= 0.5f && data.getFloraDensity() >= 0.5f && (double)world.func_180494_b(start).func_185360_m() < 0.15) {
            return false;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                for (int y = -depth; y <= depth; ++y) {
                    BlockPos pos = start.func_177982_a(x, y, z);
                    IBlockState current = world.func_180495_p(pos);
                    if (BlocksTFC.isGrass(current)) {
                        world.func_180501_a(pos, BlocksTFC.PEAT_GRASS.func_176223_P(), 2);
                        continue;
                    }
                    if (!BlocksTFC.isDirt(current) && !BlocksTFC.isClay(current)) continue;
                    world.func_180501_a(pos, BlocksTFC.PEAT.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

