/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

@ParametersAreNonnullByDefault
public class WorldGenSandTFC
extends WorldGenerator {
    private final int radius;

    public WorldGenSandTFC(int radius) {
        this.radius = radius;
    }

    public boolean func_180709_b(World world, Random rng, BlockPos pos) {
        if (BlocksTFC.isWater(world.func_180495_p(pos))) {
            return false;
        }
        BlockRockVariant sand = BlockRockVariant.get(ChunkDataTFC.getRock1(world, pos), Rock.Type.SAND);
        int rnd = rng.nextInt(this.radius - 2) + 2;
        for (int x = -rnd; x <= rnd; ++x) {
            for (int z = -rnd; z <= rnd; ++z) {
                if (x * x + z * z > rnd * rnd) continue;
                for (int y = -2; y <= 2; ++y) {
                    IBlockState s = world.func_180495_p(pos.func_177982_a(x, y, z));
                    if (!BlocksTFC.isSoil(s) && !BlocksTFC.isSand(s)) continue;
                    world.func_180501_a(pos.func_177982_a(x, y, z), sand.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

