/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.vein.Vein;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOreVeins
implements IWorldGenerator {
    private static final Random LOCAL_RANDOM = new Random();
    public static int CHUNK_RADIUS = 1;

    public static List<Vein> getNearbyVeins(int chunkX, int chunkZ, long worldSeed, int radius) {
        ArrayList<Vein> veins = new ArrayList<Vein>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                WorldGenOreVeins.getVeinsAtChunk(veins, chunkX + x, chunkZ + z, worldSeed);
            }
        }
        return veins;
    }

    private static void getVeinsAtChunk(List<Vein> listToAdd, int chunkX, int chunkZ, long worldSeed) {
        LOCAL_RANDOM.setSeed(worldSeed + (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        listToAdd.addAll(VeinRegistry.INSTANCE.getVeins().values().stream().filter(veinType -> LOCAL_RANDOM.nextInt(veinType.getRarity()) == 0).map(veinType -> veinType.createVein(LOCAL_RANDOM, chunkX, chunkZ)).collect(Collectors.toList()));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkGenTFC)) {
            return;
        }
        BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        ChunkDataTFC chunkData = ChunkDataTFC.get(world, chunkBlockPos);
        if (!chunkData.isInitialized()) {
            return;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        List<Vein> veins = WorldGenOreVeins.getNearbyVeins(chunkX, chunkZ, world.func_72905_C(), CHUNK_RADIUS);
        for (Vein vein : veins) {
            boolean generated = false;
            for (int x = chunkBlockPos.func_177958_n() + 8; x < chunkBlockPos.func_177958_n() + 24; ++x) {
                for (int z = chunkBlockPos.func_177952_p() + 8; z < chunkBlockPos.func_177952_p() + 24; ++z) {
                    if (!vein.inRange(x, z, 0)) continue;
                    for (int y = vein.getLowestY(); y <= vein.getHighestY(); ++y) {
                        BlockRockVariant blockAt;
                        BlockPos posAt = new BlockPos(x, y, z);
                        IBlockState stateAt = world.func_180495_p(posAt);
                        if (!(random.nextDouble() < vein.getChanceToGenerate(posAt)) || !(stateAt.func_177230_c() instanceof BlockRockVariant) || (blockAt = (BlockRockVariant)stateAt.func_177230_c()).getType() != Rock.Type.RAW || !vein.canSpawnIn(blockAt.getRock())) continue;
                        world.func_180501_a(posAt, vein.getOreState(blockAt.getRock()), 2);
                        generated = true;
                    }
                }
            }
            if (vein.getType() == null) continue;
            if (generated) {
                chunkData.markVeinGenerated(vein);
                continue;
            }
            if (!ConfigTFC.General.DEBUG.enable) continue;
            TerraFirmaCraft.getLog().debug("Failed to generate vein '{}' in chunk ({}, {}). Vein center pos ({}x, {}y, {}z)", (Object)vein.getType().getRegistryName(), (Object)chunkX, (Object)chunkZ, (Object)vein.getPos().func_177958_n(), (Object)vein.getPos().func_177956_o(), (Object)vein.getPos().func_177952_p());
        }
    }
}

