/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.Random;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenLargeRocks
implements IWorldGenerator {
    public void generate(Random rng, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        BlockPos start = world.func_175672_r(chunkBlockPos.func_177982_a(8 + rng.nextInt(16), 0, 8 + rng.nextInt(16))).func_177982_a(0, -1, 0);
        if (start.func_177956_o() > 155 && !BlocksTFC.isSoil(world.func_180495_p(start))) {
            return;
        }
        int y = 1;
        boolean isFlatEnough = false;
        block0: while (y-- > -2 && !isFlatEnough) {
            if (!world.func_180495_p(start.func_177982_a(0, y, 0)).func_185898_k()) continue;
            for (int x = -6; x <= 6; ++x) {
                for (int z = -6; z <= 6; ++z) {
                    if (!world.func_180495_p(start.func_177982_a(x, y, z)).func_185898_k()) continue block0;
                }
            }
            isFlatEnough = true;
        }
        if (!isFlatEnough) {
            return;
        }
        this.genFromPoint(world, rng, start.func_177982_a(0, y, 0));
        if (rng.nextInt(1) == 0) {
            this.genFromPoint(world, rng, start.func_177982_a((rng.nextInt(2) + 1) * (rng.nextBoolean() ? 1 : -1), y + (rng.nextInt(2) + 1) * (rng.nextBoolean() ? 1 : -1), (rng.nextInt(2) + 1) * (rng.nextBoolean() ? 1 : -1)));
        }
    }

    private void genFromPoint(World world, Random rng, BlockPos start) {
        Rock rock = ChunkDataTFC.getRockHeight(world, start);
        int size = rng.nextInt(10) == 0 ? 4 : 3;
        for (int x = -size; x <= size; ++x) {
            for (int z = -size; z <= size; ++z) {
                for (int y = -2; y <= 2; ++y) {
                    if (x * x + z * z + y * y > size * size) continue;
                    world.func_175656_a(start.func_177982_a(x, y, z), BlockRockVariant.get(rock, Rock.Type.RAW).func_176223_P());
                }
            }
        }
    }
}

