/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.IBerryBush;
import net.dries007.tfc.objects.blocks.agriculture.BlockBerryBush;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenBerryBushes
implements IWorldGenerator {
    private static final List<IBerryBush> BUSHES = new ArrayList<IBerryBush>();

    public static void register(IBerryBush bush) {
        BUSHES.add(bush);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof ChunkGenTFC && world.field_73011_w.getDimension() == 0 && BUSHES.size() > 0 && ConfigTFC.General.FOOD.berryBushRarity > 0 && random.nextInt(ConfigTFC.General.FOOD.berryBushRarity) == 0) {
            Collections.shuffle(BUSHES);
            BlockPos chunkBlockPos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            float temperature = ClimateTFC.getAvgTemp(world, chunkBlockPos);
            float rainfall = ChunkDataTFC.getRainfall(world, chunkBlockPos);
            IBerryBush bush = BUSHES.stream().filter(x -> x.isValidConditions(temperature, rainfall)).findFirst().orElse(null);
            if (bush != null) {
                int z;
                int x2 = (chunkX << 4) + random.nextInt(16) + 8;
                BlockPos pos = world.func_175672_r(new BlockPos(x2, 0, z = (chunkZ << 4) + random.nextInt(16) + 8));
                if (world.func_180495_p(pos).func_185904_a().func_76224_d() || !world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                    return;
                }
                BlockBerryBush block = BlockBerryBush.get(bush);
                if (block.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, block.func_176223_P());
                }
            }
        }
    }
}

