/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.mapgen;

import java.util.Random;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.world.classic.ChunkGenTFC;
import net.dries007.tfc.world.classic.DataLayer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.registries.ForgeRegistry;

public class MapGenCavesTFC
extends MapGenBase {
    private final DataLayer[] stabilityLayer;
    private int[] rockLayer1;
    private float rainfall = 0.0f;

    public MapGenCavesTFC(DataLayer[] stabilityLayer) {
        this.stabilityLayer = stabilityLayer;
    }

    public void setGenerationData(float rainfall, int[] rockLayer1) {
        this.rainfall = rainfall;
        this.rockLayer1 = rockLayer1;
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer primer) {
        int runs = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(40) + 1) + 1);
        int xCoord = chunkX * 16 + this.field_75038_b.nextInt(16);
        int yCoord = this.field_75038_b.nextInt(1 + this.field_75038_b.nextInt(140)) + 60;
        int zCoord = chunkZ * 16 + this.field_75038_b.nextInt(16);
        int dlIndex = (zCoord & 0xF) << 4 | xCoord & 0xF;
        double width = 1.5 + (double)this.rainfall / 500.0;
        int caveChance = 30 + (int)((double)this.rainfall / 50.0);
        width += (double)((Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer1[dlIndex])).getRockCategory().getCaveGenMod();
        runs = (int)((float)runs + ((Rock)((ForgeRegistry)TFCRegistries.ROCKS).getValue(this.rockLayer1[dlIndex])).getRockCategory().getCaveFreqMod());
        width = yCoord < 32 ? (width *= 0.5) : (yCoord < 64 ? (width *= 0.65) : (yCoord < 96 ? (width *= 0.8) : (yCoord < 120 ? (width *= 0.9) : (width *= 0.5))));
        if (this.field_75038_b.nextInt(8) == 0) {
            width += 1.0;
        }
        if (this.field_75038_b.nextInt(caveChance) != 0) {
            return;
        }
        for (int i = 0; i < runs; ++i) {
            int runs2 = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.field_75038_b.nextLong(), originalX, originalZ, primer, xCoord, yCoord, zCoord);
                runs2 += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < runs2; ++j) {
                float d1 = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float d2 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float d3 = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    d3 *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.field_75038_b.nextLong(), originalX, originalZ, primer, xCoord, yCoord, zCoord, d3, d1, d2, 0, 1.0, width);
            }
        }
    }

    protected void generateLargeCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double x, double y, double z) {
        this.generateCaveNode(seed, chunkX, chunkZ, primer, x, y, z, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, 0.5, 2.5);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double xOffset, double yOffset, double zOffset, float f1, float f2, float f3, int i1, double yRadiusMult, double width) {
        boolean smallRnd;
        Random rng = new Random(seed);
        int worldX = chunkX * 16 + 8;
        int worldZ = chunkZ * 16 + 8;
        float lf1 = 0.0f;
        float lf2 = 0.0f;
        int rndRange = this.field_75040_a * 16 - 16 - rng.nextInt((this.field_75040_a * 16 - 16) / 4);
        boolean onlyOne = false;
        if (i1 == -1) {
            i1 = rndRange / 2;
            onlyOne = true;
        }
        int rndRange2 = rng.nextInt(rndRange / 2) + rndRange / 4;
        boolean bl = smallRnd = rng.nextInt(6) == 0;
        while (i1 < rndRange) {
            block22: {
                float var33 = MathHelper.func_76134_b((float)f3);
                float var34 = MathHelper.func_76126_a((float)f3);
                xOffset += (double)(MathHelper.func_76134_b((float)f2) * var33);
                yOffset += (double)var34;
                zOffset += (double)(MathHelper.func_76126_a((float)f2) * var33);
                f3 *= smallRnd ? 0.92f : 0.7f;
                f3 += lf2 * 0.1f;
                f2 += lf1 * 0.1f;
                lf2 *= 0.9f;
                lf1 *= 0.75f;
                lf2 += (rng.nextFloat() - rng.nextFloat()) * rng.nextFloat() * 2.0f;
                lf1 += (rng.nextFloat() - rng.nextFloat()) * rng.nextFloat() * 4.0f;
                if (!onlyOne && i1 == rndRange2 && f1 > 1.0f && rndRange > 0) {
                    this.generateCaveNode(rng.nextLong(), chunkX, chunkZ, primer, xOffset, yOffset, zOffset, rng.nextFloat() * 0.5f + 0.5f, f2 - 1.5707964f, f3 / 3.0f, i1, 1.0, width);
                    this.generateCaveNode(rng.nextLong(), chunkX, chunkZ, primer, xOffset, yOffset, zOffset, rng.nextFloat() * 0.5f + 0.5f, f2 + 1.5707964f, f3 / 3.0f, i1, 1.0, width);
                    return;
                }
                double radius = width + (double)(MathHelper.func_76126_a((float)((float)i1 * (float)Math.PI / (float)rndRange)) * f1 * 1.0f);
                double yRadius = radius * yRadiusMult;
                if (onlyOne || rng.nextInt(4) != 0) {
                    double localXOffset = xOffset - (double)worldX;
                    double localZOffset = zOffset - (double)worldZ;
                    double var39 = rndRange - i1;
                    double var41 = f1 + 2.0f + 16.0f;
                    if (localXOffset * localXOffset + localZOffset * localZOffset - var39 * var39 > var41 * var41) {
                        return;
                    }
                    if (xOffset >= (double)worldX - 16.0 - radius * 2.0 && zOffset >= (double)worldZ - 16.0 - radius * 2.0 && xOffset <= (double)worldX + 16.0 + radius * 2.0 && zOffset <= (double)worldZ + 16.0 + radius * 2.0) {
                        int xCoord;
                        int initialX = MathHelper.func_76128_c((double)(xOffset - radius)) - chunkX * 16 - 1;
                        int maxX = MathHelper.func_76128_c((double)(xOffset + radius)) - chunkX * 16 + 1;
                        int minY = MathHelper.func_76128_c((double)(yOffset - yRadius)) - 1;
                        int initialY = MathHelper.func_76128_c((double)(yOffset + yRadius)) + 1;
                        int initialZ = MathHelper.func_76128_c((double)(zOffset - radius)) - chunkZ * 16 - 1;
                        int maxZ = MathHelper.func_76128_c((double)(zOffset + radius)) - chunkZ * 16 + 1;
                        if (initialX < 0) {
                            initialX = 0;
                        }
                        if (maxX > 16) {
                            maxX = 16;
                        }
                        if (minY < 1) {
                            minY = 1;
                        }
                        if (initialY > 250) {
                            initialY = 250;
                        }
                        if (initialZ < 0) {
                            initialZ = 0;
                        }
                        if (maxZ > 16) {
                            maxZ = 16;
                        }
                        for (xCoord = Math.max(initialX - 1, 0); xCoord < Math.min(maxX + 1, 16); ++xCoord) {
                            for (int zCoord = Math.max(initialZ - 1, 0); zCoord < Math.min(maxZ + 1, 16); ++zCoord) {
                                for (int yCoord = Math.min(initialY + 1, 250); yCoord > Math.max(minY - 1, 0); --yCoord) {
                                    if (!BlocksTFC.isWater(primer.func_177856_a(xCoord, yCoord, zCoord))) {
                                        continue;
                                    }
                                    break block22;
                                }
                            }
                        }
                        for (xCoord = initialX; xCoord < maxX; ++xCoord) {
                            double xDistNorm = ((double)(xCoord + chunkX * 16) + 0.5 - xOffset) / radius;
                            for (int zCoord = initialZ; zCoord < maxZ; ++zCoord) {
                                double zDistNorm = ((double)(zCoord + chunkZ * 16) + 0.5 - zOffset) / radius;
                                if (xDistNorm * xDistNorm + zDistNorm * zDistNorm >= 1.0) continue;
                                IBlockState grass = null;
                                for (int y = initialY - 1; y >= minY; --y) {
                                    IBlockState current;
                                    double yNorm = ((double)y + 0.5 - yOffset) / yRadius;
                                    if (!(yNorm > -0.7) || !(xDistNorm * xDistNorm + yNorm * yNorm + zDistNorm * zDistNorm < 1.0) || !BlocksTFC.isSoil(current = primer.func_177856_a(xCoord, y, zCoord)) && !BlocksTFC.isRawStone(current)) continue;
                                    if (BlocksTFC.isGrass(current)) {
                                        grass = primer.func_177856_a(xCoord, y, zCoord);
                                    }
                                    int upCount = 1;
                                    while (BlocksTFC.isSoilOrGravel(primer.func_177856_a(xCoord, y + upCount, zCoord))) {
                                        primer.func_177855_a(xCoord, y + upCount, zCoord, ChunkGenTFC.AIR);
                                        ++upCount;
                                    }
                                    if (y < 20 && this.stabilityLayer[(worldZ & 0xF) << 4 | worldX & 0xF].valueInt == 1) {
                                        primer.func_177855_a(xCoord, y, zCoord, ChunkGenTFC.LAVA);
                                        continue;
                                    }
                                    primer.func_177855_a(xCoord, y, zCoord, ChunkGenTFC.AIR);
                                    if (grass == null || !BlocksTFC.isDirt(primer.func_177856_a(xCoord, y - 1, zCoord))) continue;
                                    primer.func_177855_a(xCoord, y - 1, zCoord, grass);
                                }
                            }
                        }
                        if (onlyOne) break;
                    }
                }
            }
            ++i1;
        }
    }
}

