/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.genlayers.biome;

import java.util.Arrays;
import java.util.Objects;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.dries007.tfc.world.classic.genlayers.GenLayerTFC;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeTFC
extends GenLayerTFC {
    private final int[] biomes = BiomesTFC.getWorldGenBiomes().stream().mapToInt(Biome::func_185362_a).toArray();

    public GenLayerBiomeTFC(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
        if (ConfigTFC.General.DEBUG.debugWorldGenSafe) {
            TerraFirmaCraft.getLog().info("Worldgen biome list (ints): {}", (Object)this.biomes);
            TerraFirmaCraft.getLog().info("Worldgen biome list (names): {}", (Object)Arrays.stream(this.biomes).mapToObj(Biome::func_185357_a).map(Objects::toString).toArray());
        }
    }

    public int[] func_75904_a(int x, int y, int sizeX, int sizeY) {
        int[] ints = this.field_75909_a.func_75904_a(x, y, sizeX, sizeY);
        int[] out = IntCache.func_76445_a((int)(sizeX * sizeY));
        for (int yy = 0; yy < sizeY; ++yy) {
            for (int xx = 0; xx < sizeX; ++xx) {
                this.func_75903_a(xx + x, yy + y);
                int id = ints[xx + yy * sizeX];
                out[xx + yy * sizeX] = this.isOceanicBiome(id) ? id : this.biomes[this.func_75902_a(this.biomes.length)];
            }
        }
        return out;
    }
}

