/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic.biomes;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.classic.biomes.BiomeTFC;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="tfc")
@GameRegistry.ObjectHolder(value="tfc")
public final class BiomesTFC {
    public static final BiomeTFC OCEAN = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC RIVER = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC BEACH = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC GRAVEL_BEACH = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC HIGH_HILLS = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC PLAINS = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC SWAMPLAND = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC HIGH_HILLS_EDGE = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC ROLLING_HILLS = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC MOUNTAINS = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC MOUNTAINS_EDGE = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC HIGH_PLAINS = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC DEEP_OCEAN = (BiomeTFC)((Object)Helpers.getNull());
    public static final BiomeTFC LAKE = (BiomeTFC)((Object)Helpers.getNull());
    private static final List<Biome> SPAWN_BIOMES = new ArrayList<Biome>();
    private static final List<Biome> WORLD_GEN_BIOMES = new ArrayList<Biome>();

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry r = event.getRegistry();
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(3289800, new Biome.BiomeProperties("TerraFirmaCraft Ocean").func_185398_c(-2.6f).func_185400_d(-2.69999f)), false, true, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(2854074, new Biome.BiomeProperties("TerraFirmaCraft River").func_185398_c(-2.3f).func_185400_d(-3.0f)), false, false, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(13082683, new Biome.BiomeProperties("TerraFirmaCraft Beach").func_185398_c(-1.69f).func_185400_d(-2.68f)), false, false, BiomeDictionary.Type.BEACH);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(8287312, new Biome.BiomeProperties("TerraFirmaCraft Gravel Beach").func_185398_c(-1.69f).func_185400_d(-2.68f).func_185399_a("tfc:beach")), false, false, BiomeDictionary.Type.BEACH);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(9568370, new Biome.BiomeProperties("TerraFirmaCraft High Hills").func_185398_c(-0.9000001f).func_185400_d(-1.1f)), false, true, BiomeDictionary.Type.HILLS);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(3435301, new Biome.BiomeProperties("TerraFirmaCraft Plains").func_185398_c(-1.6000001f).func_185400_d(-2.54f)).setSpawnBiome(), true, true, BiomeDictionary.Type.PLAINS);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(627200, new Biome.BiomeProperties("TerraFirmaCraft Swampland").func_185398_c(-1.8f).func_185400_d(-2.6000001f), 16, 45).setSpawnBiome(), true, true, BiomeDictionary.Type.SWAMP);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(9590396, new Biome.BiomeProperties("TerraFirmaCraft High Hills Edge").func_185398_c(-1.5f).func_185400_d(-2.3f).func_185399_a("tfc:high_hills")), false, false, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.PLAINS);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(7555986, new Biome.BiomeProperties("TerraFirmaCraft Rolling Hills").func_185398_c(-1.6000001f).func_185400_d(-2.3f)).setSpawnBiome(), true, true, BiomeDictionary.Type.HILLS);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(0x920000, new Biome.BiomeProperties("TerraFirmaCraft Mountains").func_185398_c(-0.9000001f).func_185400_d(-1.1f)).setSpawnBiome(), true, true, BiomeDictionary.Type.MOUNTAIN);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(9587276, new Biome.BiomeProperties("TerraFirmaCraft Mountains Edge").func_185398_c(-1.3f).func_185400_d(-1.9000001f).func_185399_a("tfc:mountains")).setSpawnBiome(), true, false, BiomeDictionary.Type.MOUNTAIN);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(2248753, new Biome.BiomeProperties("TerraFirmaCraft High Plains").func_185398_c(-1.3f).func_185400_d(-2.27f)).setSpawnBiome(), true, true, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.PLAINS);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(128, new Biome.BiomeProperties("TerraFirmaCraft Deep Ocean").func_185398_c(-3.2f).func_185400_d(-2.49999f).func_185399_a("tfc:ocean")), false, false, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER);
        BiomesTFC.register((IForgeRegistry<Biome>)r, new BiomeTFC(6130829, new Biome.BiomeProperties("TerraFirmaCraft Lake").func_185398_c(-2.4f).func_185400_d(-2.5990002f).func_185399_a("tfc:ocean"), 4, 5), false, false, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER);
    }

    public static boolean isOceanicBiome(Biome b) {
        return OCEAN == b || DEEP_OCEAN == b;
    }

    public static boolean isRiverBiome(Biome b) {
        return RIVER == b;
    }

    public static boolean isLakeBiome(Biome b) {
        return LAKE == b;
    }

    public static boolean isMountainBiome(Biome b) {
        return MOUNTAINS == b || MOUNTAINS_EDGE == b;
    }

    public static boolean isBeachBiome(Biome b) {
        return BEACH == b || GRAVEL_BEACH == b;
    }

    public static List<Biome> getSpawnBiomes() {
        return SPAWN_BIOMES;
    }

    public static List<Biome> getWorldGenBiomes() {
        return WORLD_GEN_BIOMES;
    }

    private static void register(IForgeRegistry<Biome> r, Biome biome, boolean isSpawn, boolean isWorldGen, BiomeDictionary.Type ... types) {
        r.register(biome.setRegistryName("tfc", biome.field_76791_y.replace("TerraFirmaCraft ", "").replace(' ', '_').toLowerCase()));
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        if (isSpawn) {
            SPAWN_BIOMES.add(biome);
        }
        if (isWorldGen) {
            WORLD_GEN_BIOMES.add(biome);
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            biome.func_76747_a(EnumCreatureType.WATER_CREATURE).add(new Biome.SpawnListEntry(EntitySquid.class, 20, 3, 7));
        }
    }

    private BiomesTFC() {
    }
}

