/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.classic;

import java.util.ArrayList;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class WorldEntitySpawnerTFC {
    public static void init() {
        EnumCreatureType.MONSTER.field_75606_e = ConfigTFC.General.DIFFICULTY.mobSpawnCount;
        EnumCreatureType.CREATURE.field_75606_e = ConfigTFC.General.DIFFICULTY.animalSpawnCount;
    }

    public static void performWorldGenSpawning(World worldIn, Biome biomeIn, int centerX, int centerZ, int diameterX, int diameterZ, Random randomIn) {
        BlockPos chunkBlockPos = new BlockPos(centerX, 0, centerZ);
        float temperature = ClimateTFC.getAvgTemp(worldIn, chunkBlockPos);
        float rainfall = ChunkDataTFC.getRainfall(worldIn, chunkBlockPos);
        float floraDensity = ChunkDataTFC.getFloraDensity(worldIn, chunkBlockPos);
        float floraDiversity = ChunkDataTFC.getFloraDiversity(worldIn, chunkBlockPos);
        ForgeRegistries.ENTITIES.getValuesCollection().stream().filter(x -> {
            Entity ent;
            if (ICreatureTFC.class.isAssignableFrom(x.getEntityClass()) && (ent = x.newInstance(worldIn)) instanceof ICreatureTFC) {
                int weight = ((ICreatureTFC)ent).getSpawnWeight(biomeIn, temperature, rainfall, floraDensity, floraDiversity);
                return weight > 0 && randomIn.nextInt(weight) == 0;
            }
            return false;
        }).findFirst().ifPresent(entityEntry -> {
            ArrayList<EntityLiving> group = new ArrayList<EntityLiving>();
            EntityLiving creature = (EntityLiving)entityEntry.newInstance(worldIn);
            if (!(creature instanceof ICreatureTFC)) {
                return;
            }
            ICreatureTFC creatureTFC = (ICreatureTFC)creature;
            int fallback = 5;
            int individuals = Math.max(1, creatureTFC.getMinGroupSize()) + randomIn.nextInt(creatureTFC.getMaxGroupSize() - Math.max(0, creatureTFC.getMinGroupSize() - 1));
            while (individuals > 0) {
                int j = centerX + randomIn.nextInt(diameterX);
                int k = centerZ + randomIn.nextInt(diameterZ);
                BlockPos blockpos = worldIn.func_175672_r(new BlockPos(j, 0, k));
                creature.func_70012_b((double)((float)j + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k + 0.5f), randomIn.nextFloat() * 360.0f, 0.0f);
                if (creature.func_70601_bi()) {
                    if (ForgeEventFactory.canEntitySpawn((EntityLiving)creature, (World)worldIn, (float)((float)j + 0.5f), (float)blockpos.func_177956_o(), (float)((float)k + 0.5f), null) == Event.Result.DENY) {
                        if (--fallback <= 0) break;
                        continue;
                    }
                    fallback = 5;
                    worldIn.func_72838_d((Entity)creature);
                    group.add(creature);
                    creature.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)creature)), null);
                    if (--individuals <= 0) continue;
                    creature = (EntityLiving)entityEntry.newInstance(worldIn);
                    creatureTFC = (ICreatureTFC)creature;
                    continue;
                }
                if (--fallback > 0) continue;
                break;
            }
            creatureTFC.getGroupingRules().accept(group, randomIn);
        });
    }
}

